/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractEncapsulatedExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDoubleEncapsulatedExpression
extends AbstractEncapsulatedExpression {
    private AbstractExpression firstExpression;
    private boolean hasComma;
    private boolean hasSpaceAfterComma;
    private AbstractExpression secondExpression;

    protected AbstractDoubleEncapsulatedExpression(AbstractExpression parent) {
        super(parent);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getFirstExpression().accept(visitor);
        this.getSecondExpression().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getFirstExpression());
        children.add(this.getSecondExpression());
    }

    @Override
    protected void addOrderedEncapsulatedExpressionTo(List<Expression> children) {
        if (this.firstExpression != null) {
            children.add(this.firstExpression);
        }
        if (this.hasComma) {
            children.add(this.buildStringExpression(','));
        }
        if (this.hasSpaceAfterComma) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.secondExpression != null) {
            children.add(this.secondExpression);
        }
    }

    public final CollectionExpression buildCollectionExpression() {
        ArrayList<AbstractExpression> children = new ArrayList<AbstractExpression>(3);
        children.add((AbstractExpression)this.getFirstExpression());
        children.add((AbstractExpression)this.getSecondExpression());
        ArrayList<Boolean> commas = new ArrayList<Boolean>(2);
        commas.add(this.hasComma);
        commas.add(Boolean.FALSE);
        ArrayList<Boolean> spaces = new ArrayList<Boolean>(2);
        spaces.add(this.hasSpaceAfterComma);
        spaces.add(Boolean.FALSE);
        return new CollectionExpression(this, children, commas, spaces, true);
    }

    public final Expression getFirstExpression() {
        if (this.firstExpression == null) {
            this.firstExpression = this.buildNullExpression();
        }
        return this.firstExpression;
    }

    public final Expression getSecondExpression() {
        if (this.secondExpression == null) {
            this.secondExpression = this.buildNullExpression();
        }
        return this.secondExpression;
    }

    public final boolean hasComma() {
        return this.hasComma;
    }

    @Override
    public boolean hasEncapsulatedExpression() {
        return this.hasFirstExpression() || this.hasComma || this.hasSecondExpression();
    }

    public final boolean hasFirstExpression() {
        return this.firstExpression != null && !this.firstExpression.isNull();
    }

    public final boolean hasSecondExpression() {
        return this.secondExpression != null && !this.secondExpression.isNull();
    }

    public final boolean hasSpaceAfterComma() {
        return this.hasSpaceAfterComma;
    }

    @Override
    protected boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        char character = wordParser.character();
        return character == ',' || character == ')' || word.equalsIgnoreCase("AND") || word.equalsIgnoreCase("OR") || super.isParsingComplete(wordParser, word, expression);
    }

    public abstract String parameterExpressionBNF(int var1);

    @Override
    protected void parseEncapsulatedExpression(WordParser wordParser, boolean tolerant) {
        int count = 0;
        this.firstExpression = this.parse(wordParser, this.getQueryBNF(this.parameterExpressionBNF(0)), tolerant);
        if (this.hasFirstExpression()) {
            count = wordParser.skipLeadingWhitespace();
        }
        this.hasComma = wordParser.startsWith(',');
        if (this.hasComma) {
            count = 0;
            wordParser.moveForward(1);
            this.hasSpaceAfterComma = wordParser.skipLeadingWhitespace() > 0;
        } else if (this.hasFirstExpression()) {
            this.hasSpaceAfterComma = count > 0;
            count = 0;
        }
        this.secondExpression = this.parse(wordParser, this.getQueryBNF(this.parameterExpressionBNF(1)), tolerant);
        if (!this.hasSecondExpression()) {
            wordParser.moveBackward(count);
        }
    }

    @Override
    protected void toParsedTextEncapsulatedExpression(StringBuilder writer, boolean actual) {
        if (this.firstExpression != null) {
            this.firstExpression.toParsedText(writer, actual);
        }
        if (this.hasComma) {
            writer.append(',');
        }
        if (this.hasSpaceAfterComma) {
            writer.append(' ');
        }
        if (this.secondExpression != null) {
            this.secondExpression.toParsedText(writer, actual);
        }
    }
}

