/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSingleEncapsulatedExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AggregateFunction
extends AbstractSingleEncapsulatedExpression {
    private boolean hasDistinct;
    private String distinctIdentifier;
    private boolean hasSpaceAfterDistinct;

    public String getActualDistinctIdentifier() {
        return this.distinctIdentifier != null ? this.distinctIdentifier : "";
    }

    protected AggregateFunction(AbstractExpression parent) {
        super(parent);
    }

    @Override
    protected void addOrderedEncapsulatedExpressionTo(List<Expression> children) {
        if (this.hasDistinct) {
            children.add(this.buildStringExpression("DISTINCT"));
        }
        if (this.hasSpaceAfterDistinct) {
            children.add(this.buildStringExpression(' '));
        }
        super.addOrderedEncapsulatedExpressionTo(children);
    }

    protected AbstractExpression buildEncapsulatedExpression(WordParser wordParser, String word) {
        return new StateFieldPathExpression((AbstractExpression)this, word);
    }

    @Override
    public String encapsulatedExpressionBNF() {
        return "internal_aggregate_function";
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("aggregate_expression");
    }

    public final boolean hasDistinct() {
        return this.hasDistinct;
    }

    public final boolean hasSpaceAfterDistinct() {
        return this.hasSpaceAfterDistinct;
    }

    @Override
    protected final void parseEncapsulatedExpression(WordParser wordParser, boolean tolerant) {
        this.hasDistinct = wordParser.startsWithIdentifier("DISTINCT");
        if (this.hasDistinct) {
            this.distinctIdentifier = wordParser.moveForward("DISTINCT");
            this.hasSpaceAfterDistinct = wordParser.skipLeadingWhitespace() > 0;
        }
        super.parseEncapsulatedExpression(wordParser, tolerant);
    }

    @Override
    protected void toParsedTextEncapsulatedExpression(StringBuilder writer, boolean actual) {
        if (this.hasDistinct) {
            writer.append(actual ? this.distinctIdentifier : "DISTINCT");
        }
        if (this.hasSpaceAfterDistinct) {
            writer.append(' ');
        }
        super.toParsedTextEncapsulatedExpression(writer, actual);
    }
}

