/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NumericLiteral
extends AbstractExpression {
    public NumericLiteral(AbstractExpression parent, String numeric) {
        super(parent, numeric);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        children.add(this.buildStringExpression(this.getText()));
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("numeric_literal");
    }

    @Override
    public String getText() {
        return super.getText();
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        String word;
        String text = this.getText();
        wordParser.moveForward(text);
        if (Character.toUpperCase(text.charAt(text.length() - 1)) == 'E') {
            int startIndex = wordParser.position();
            int endIndex = wordParser.position();
            int count = wordParser.length();
            while (endIndex < count) {
                char character = wordParser.character(endIndex);
                if ((endIndex != startIndex || character != '-') && !Character.isDigit(character)) break;
                ++endIndex;
            }
            if (endIndex > 0) {
                text = String.valueOf(text) + wordParser.substring(wordParser.position(), endIndex);
                this.setText(text);
                wordParser.setPosition(endIndex);
            }
        } else if ((text.equals("+") || text.equals("-")) && (word = wordParser.word()).length() > 0 && Character.isDigit(word.charAt(0))) {
            text = String.valueOf(text) + word;
            wordParser.moveForward(word);
            this.setText(text);
        }
    }

    @Override
    public String toParsedText() {
        return this.getText();
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        writer.append(this.getText());
    }
}

