/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSchemaName;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RangeVariableDeclaration
extends AbstractExpression {
    private AbstractExpression abstractSchemaName;
    private String asIdentifier;
    private boolean hasAs;
    private boolean hasSpaceAfterAs;
    private boolean hasSpaceAfterSchemaName;
    private AbstractExpression identificationVariable;
    private boolean virtualIdentificationVariable;

    public RangeVariableDeclaration(AbstractExpression parent) {
        super(parent);
    }

    public RangeVariableDeclaration(String entityName, String variableName) {
        super(null);
        this.abstractSchemaName = new AbstractSchemaName(this, entityName);
        this.identificationVariable = new IdentificationVariable(this, variableName);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getAbstractSchemaName().accept(visitor);
        this.getIdentificationVariable().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getAbstractSchemaName());
        children.add(this.getIdentificationVariable());
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        if (this.abstractSchemaName != null) {
            children.add(this.abstractSchemaName);
        }
        if (this.hasSpaceAfterSchemaName) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.hasAs) {
            children.add(this.buildStringExpression("AS"));
        }
        if (this.hasSpaceAfterAs) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.identificationVariable != null) {
            children.add(this.identificationVariable);
        }
    }

    public Expression getAbstractSchemaName() {
        if (this.abstractSchemaName == null) {
            this.abstractSchemaName = this.buildNullExpression();
        }
        return this.abstractSchemaName;
    }

    public String getActualAsIdentifier() {
        return this.asIdentifier != null ? this.asIdentifier : "";
    }

    public Expression getIdentificationVariable() {
        if (this.identificationVariable == null) {
            this.identificationVariable = this.buildNullExpression();
        }
        return this.identificationVariable;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("range_variable_declaration");
    }

    public boolean hasAbstractSchemaName() {
        return this.abstractSchemaName != null && !this.abstractSchemaName.isNull();
    }

    public boolean hasAs() {
        return this.hasAs;
    }

    public boolean hasIdentificationVariable() {
        return this.identificationVariable != null && !this.identificationVariable.isNull() && !this.identificationVariable.isVirtual();
    }

    public boolean hasSpaceAfterAbstractSchemaName() {
        return this.hasSpaceAfterSchemaName;
    }

    public boolean hasSpaceAfterAs() {
        return this.hasSpaceAfterAs;
    }

    public boolean hasVirtualIdentificationVariable() {
        return this.virtualIdentificationVariable;
    }

    @Override
    protected boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        return word.equalsIgnoreCase("SET") || word.equalsIgnoreCase("INNER") || word.equalsIgnoreCase("JOIN") || word.equalsIgnoreCase("LEFT") || super.isParsingComplete(wordParser, word, expression);
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        this.abstractSchemaName = this.parseAbstractSchemaName(wordParser, tolerant);
        this.hasSpaceAfterSchemaName = wordParser.skipLeadingWhitespace() > 0;
        this.hasAs = wordParser.startsWithIdentifier("AS");
        if (this.hasAs) {
            this.asIdentifier = wordParser.moveForward("AS");
            boolean bl = this.hasSpaceAfterAs = wordParser.skipLeadingWhitespace() > 0;
        }
        if (!wordParser.startsWithIdentifier("SET")) {
            this.identificationVariable = this.parseIdentificationVariable(wordParser, tolerant);
        }
    }

    private AbstractExpression parseAbstractSchemaName(WordParser wordParser, boolean tolerant) {
        if (tolerant) {
            if (wordParser.startsWithIdentifier("AS")) {
                return null;
            }
            return this.parse(wordParser, this.getQueryBNF("abstract_schema_name"), tolerant);
        }
        String word = wordParser.word();
        AbstractExpression expression = word.indexOf(46) != -1 ? new CollectionValuedPathExpression((AbstractExpression)this, word) : new AbstractSchemaName(this, word);
        expression.parse(wordParser, tolerant);
        return expression;
    }

    private AbstractExpression parseIdentificationVariable(WordParser wordParser, boolean tolerant) {
        if (tolerant) {
            return this.parse(wordParser, this.getQueryBNF("identification_variable"), tolerant);
        }
        IdentificationVariable expression = new IdentificationVariable(this, wordParser.word());
        ((AbstractExpression)expression).parse(wordParser, tolerant);
        return expression;
    }

    public void setVirtualIdentificationVariable(String variableName) {
        this.virtualIdentificationVariable = true;
        this.identificationVariable = new IdentificationVariable(this, variableName, true);
    }

    public void setVirtualIdentificationVariable(String variableName, String path) {
        this.setVirtualIdentificationVariable(variableName);
        CollectionValuedPathExpression expression = new CollectionValuedPathExpression((AbstractExpression)this, path);
        expression.setVirtualIdentificationVariable(variableName);
        this.abstractSchemaName = expression;
    }

    @Override
    protected boolean shouldParseWithFactoryFirst() {
        return false;
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        if (this.abstractSchemaName != null) {
            this.abstractSchemaName.toParsedText(writer, actual);
        }
        if (this.hasSpaceAfterSchemaName) {
            writer.append(' ');
        }
        if (this.hasAs) {
            writer.append(actual ? this.asIdentifier : "AS");
        }
        if (this.hasSpaceAfterAs) {
            writer.append(' ');
        }
        if (this.identificationVariable != null && !this.virtualIdentificationVariable) {
            this.identificationVariable.toParsedText(writer, actual);
        }
    }
}

