/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractEncapsulatedExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.EntityTypeLiteral;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TreatExpression
extends AbstractEncapsulatedExpression {
    private String asIdentifier;
    private AbstractExpression collectionValuedPathExpression;
    private AbstractExpression entityType;
    private boolean hasAs;
    private boolean hasSpaceAfterAs;
    private boolean hasSpaceAfterCollectionValuedPathExpression;

    public TreatExpression(AbstractExpression parent) {
        super(parent);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        this.acceptUnknownVisitor(visitor);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getCollectionValuedPathExpression().accept(visitor);
        this.getEntityType().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getCollectionValuedPathExpression());
        children.add(this.getEntityType());
    }

    @Override
    protected void addOrderedEncapsulatedExpressionTo(List<Expression> children) {
        if (this.collectionValuedPathExpression != null) {
            children.add(this.collectionValuedPathExpression);
        }
        if (this.hasSpaceAfterCollectionValuedPathExpression) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.hasAs) {
            children.add(this.buildStringExpression("AS"));
        }
        if (this.hasSpaceAfterAs) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.entityType != null) {
            children.add(this.entityType);
        }
    }

    public String getActualAsIdentifier() {
        return this.asIdentifier != null ? this.asIdentifier : "";
    }

    public Expression getCollectionValuedPathExpression() {
        if (this.collectionValuedPathExpression == null) {
            this.collectionValuedPathExpression = this.buildNullExpression();
        }
        return this.collectionValuedPathExpression;
    }

    public Expression getEntityType() {
        if (this.entityType == null) {
            this.entityType = this.buildNullExpression();
        }
        return this.entityType;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("treat_expression");
    }

    public boolean hasAs() {
        return this.hasAs;
    }

    public boolean hasCollectionValuedPathExpression() {
        return this.collectionValuedPathExpression != null && !this.collectionValuedPathExpression.isNull();
    }

    @Override
    public boolean hasEncapsulatedExpression() {
        return this.hasCollectionValuedPathExpression() || this.hasAs || this.hasEntityType();
    }

    public boolean hasEntityType() {
        return this.entityType != null && !this.entityType.isNull();
    }

    public boolean hasSpaceAfterAs() {
        return this.hasSpaceAfterAs;
    }

    public boolean hasSpaceAfterCollectionValuedPathExpression() {
        return this.hasSpaceAfterCollectionValuedPathExpression;
    }

    @Override
    protected void parseEncapsulatedExpression(WordParser wordParser, boolean tolerant) {
        if (tolerant) {
            this.collectionValuedPathExpression = this.parse(wordParser, this.getQueryBNF("collection_valued_path_expression"), tolerant);
        } else {
            this.collectionValuedPathExpression = new CollectionValuedPathExpression((AbstractExpression)this, wordParser.word());
            this.collectionValuedPathExpression.parse(wordParser, tolerant);
        }
        this.hasSpaceAfterCollectionValuedPathExpression = wordParser.skipLeadingWhitespace() > 0;
        this.hasAs = wordParser.startsWithIdentifier("AS");
        if (this.hasAs) {
            this.asIdentifier = wordParser.moveForward("AS");
            boolean bl = this.hasSpaceAfterAs = wordParser.skipLeadingWhitespace() > 0;
        }
        if (tolerant) {
            this.entityType = this.parse(wordParser, this.getQueryBNF("entity_type_literal"), tolerant);
        } else {
            this.entityType = new EntityTypeLiteral(this, wordParser.word());
            this.entityType.parse(wordParser, tolerant);
        }
    }

    @Override
    protected String parseIdentifier(WordParser wordParser) {
        return "TREAT";
    }

    @Override
    protected void toParsedTextEncapsulatedExpression(StringBuilder writer, boolean actual) {
        if (this.collectionValuedPathExpression != null) {
            writer.append(this.collectionValuedPathExpression);
        }
        if (this.hasSpaceAfterCollectionValuedPathExpression) {
            writer.append(' ');
        }
        if (this.hasAs) {
            writer.append(actual ? this.asIdentifier : "AS");
        }
        if (this.hasSpaceAfterAs) {
            writer.append(' ');
        }
        if (this.entityType != null) {
            writer.append(this.entityType);
        }
    }
}

