/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.nosql.adapters.mongo;

import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.ServerAddress;
import java.util.ArrayList;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoAdapterMetaData;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoConnection;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoJCAConnectionSpec;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoRecordFactory;

public class MongoConnectionFactory
implements ConnectionFactory {
    protected Mongo mongo;
    protected DB db;

    public MongoConnectionFactory() {
    }

    public MongoConnectionFactory(Mongo mongo) {
        this.mongo = mongo;
    }

    public MongoConnectionFactory(DB db) {
        this.db = db;
    }

    public Connection getConnection() throws ResourceException {
        return this.getConnection(new MongoJCAConnectionSpec());
    }

    public Connection getConnection(ConnectionSpec spec) throws ResourceException {
        MongoJCAConnectionSpec connectionSpec = (MongoJCAConnectionSpec)spec;
        DB db = this.db;
        boolean isExternal = true;
        if (db == null) {
            try {
                Mongo mongo;
                ArrayList<ServerAddress> servers = new ArrayList<ServerAddress>();
                for (int index = 0; index < connectionSpec.getHosts().size(); ++index) {
                    String host = connectionSpec.getHosts().get(index);
                    int port = ServerAddress.defaultPort();
                    if (connectionSpec.getPorts().size() > index) {
                        port = connectionSpec.getPorts().get(index);
                    }
                    ServerAddress server = new ServerAddress(host, port);
                    servers.add(server);
                }
                if (connectionSpec.getHosts().isEmpty()) {
                    ServerAddress server = new ServerAddress("localhost", ServerAddress.defaultPort());
                    servers.add(server);
                }
                if ((mongo = this.mongo) == null) {
                    isExternal = false;
                    mongo = servers.isEmpty() ? new Mongo() : new Mongo(servers);
                }
                db = mongo.getDB(connectionSpec.getDB());
                if (connectionSpec.getUser() != null && connectionSpec.getUser().length() > 0) {
                    db.authenticate(connectionSpec.getUser(), connectionSpec.getPassword());
                }
                if (connectionSpec.getOptions() > 0) {
                    db.setOptions(connectionSpec.getOptions());
                }
                if (connectionSpec.getReadPreference() != null) {
                    db.setReadPreference(connectionSpec.getReadPreference());
                }
                if (connectionSpec.getWriteConcern() != null) {
                    db.setWriteConcern(connectionSpec.getWriteConcern());
                }
            }
            catch (Exception exception) {
                ResourceException resourceException = new ResourceException(exception.toString());
                resourceException.initCause((Throwable)exception);
                throw resourceException;
            }
        }
        return new MongoConnection(db, isExternal, connectionSpec);
    }

    public ResourceAdapterMetaData getMetaData() {
        return new MongoAdapterMetaData();
    }

    public RecordFactory getRecordFactory() {
        return new MongoRecordFactory();
    }

    public Reference getReference() {
        return new Reference(this.getClass().getName());
    }

    public void setReference(Reference reference) {
    }

    public Mongo getMongo() {
        return this.mongo;
    }

    public void setMongo(Mongo mongo) {
        this.mongo = mongo;
    }

    public DB getDb() {
        return this.db;
    }

    public void setDb(DB db) {
        this.db = db;
    }
}

