/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.branding;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rap.ui.branding.IExitConfirmation;
import org.eclipse.rap.ui.internal.branding.Branding;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.application.ApplicationConfiguration;
import org.eclipse.rwt.branding.AbstractBranding;
import org.eclipse.rwt.internal.application.ApplicationContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BrandingExtension {
    private static final String EP_BRANDING = "org.eclipse.rap.ui.branding";
    private static final String ATT_ID = "id";
    private static final String ATT_DEFAULT_ENTRYPOINT_ID = "defaultEntrypointId";
    private static final String ATT_EXIT_CONFIRMATION_CLASS = "exitConfirmationClass";
    private static final String ATT_THEME_ID = "themeId";
    private static final String ATT_FAVICON = "favicon";
    private static final String ATT_SERVLET_NAME = "servletName";
    private static final String ATT_TITLE = "title";
    private static final String ATT_BODY = "body";
    private static final String ELEM_ADITIONAL_HEADERS = "additionalHeaders";
    private static final String ELEM_ENTRYPOINTS = "associatedEntrypoints";
    private static final String TAG_META = "meta";
    private static final String TAG_LINK = "link";
    private static final String ELEM_ATTRIBUTE = "attribute";
    private static final String ATT_NAME = "name";
    private static final String ATT_CONTENT = "content";
    private static final String ATT_REL = "rel";
    private static final String ATT_HREF = "href";
    private static final String ATT_VALUE = "value";
    private static final String ELEM_SERVICE_SELECTOR = "httpServiceFilter";
    private static final String ATT_CLASS = "class";
    private final ApplicationConfiguration configuration;
    private final ServiceReference<HttpService> httpServiceReference;

    public BrandingExtension(ApplicationConfiguration configuration, ServiceReference<HttpService> httpServiceReference) {
        this.configuration = configuration;
        this.httpServiceReference = httpServiceReference;
    }

    public void read() throws IOException {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(EP_BRANDING);
        IConfigurationElement[] brandings = ep.getConfigurationElements();
        int i = 0;
        while (i < brandings.length) {
            IConfigurationElement configElement = brandings[i];
            this.readBranding(configElement);
            ++i;
        }
        this.registerDefaultServletName();
    }

    private void readBranding(IConfigurationElement element) throws IOException {
        IConfigurationElement[] entryPoints;
        String contributor = element.getContributor().getName();
        String defEntryPointId = element.getAttribute(ATT_DEFAULT_ENTRYPOINT_ID);
        String id = element.getAttribute(ATT_ID);
        String body = element.getAttribute(ATT_BODY);
        String title = element.getAttribute(ATT_TITLE);
        String servletName = element.getAttribute(ATT_SERVLET_NAME);
        String favIcon = element.getAttribute(ATT_FAVICON);
        String themeId = element.getAttribute(ATT_THEME_ID);
        IExitConfirmation exitConfirmation = this.findExitConfirmationImpl(element);
        Branding branding = new Branding(contributor);
        branding.setId(id);
        branding.setBody(this.readBody(contributor, body));
        branding.setTitle(title);
        branding.setThemeId(themeId);
        branding.setFavIcon(favIcon);
        branding.setServletName(servletName);
        branding.setExitConfirmation(exitConfirmation);
        branding.setDefaultEntryPointId(defEntryPointId);
        IConfigurationElement[] additionalHeaders = element.getChildren(ELEM_ADITIONAL_HEADERS);
        if (additionalHeaders.length > 0) {
            IConfigurationElement additionalHeader = additionalHeaders[0];
            this.readAdditionalHeader(branding, additionalHeader);
        }
        if ((entryPoints = element.getChildren(ELEM_ENTRYPOINTS)).length > 0) {
            entryPoints = entryPoints[0].getChildren();
            int i = 0;
            while (i < entryPoints.length) {
                String entryPointId = entryPoints[i].getAttribute(ATT_ID);
                branding.addEntryPointId(entryPointId);
                ++i;
            }
        }
        if (!this.isFiltered(element)) {
            this.register(branding);
        }
    }

    private boolean isFiltered(IConfigurationElement element) {
        boolean result = false;
        if (this.httpServiceReference != null) {
            Filter serviceFilter = this.readServiceFilter(element);
            result = serviceFilter != null && !serviceFilter.match(this.httpServiceReference);
        }
        return result;
    }

    private Filter readServiceFilter(IConfigurationElement element) {
        IConfigurationElement serviceFilterElement;
        String filterClass;
        Filter result = null;
        IConfigurationElement[] serviceFilterElements = element.getChildren(ELEM_SERVICE_SELECTOR);
        if (serviceFilterElements.length > 0 && (filterClass = (serviceFilterElement = serviceFilterElements[0]).getAttribute(ATT_CLASS)) != null) {
            try {
                result = (Filter)serviceFilterElement.createExecutableExtension(ATT_CLASS);
            }
            catch (CoreException exception) {
                String message = "Could not instantiate http service filter for branding: " + filterClass;
                throw new IllegalArgumentException(message, exception);
            }
        }
        return result;
    }

    private IExitConfirmation findExitConfirmationImpl(IConfigurationElement element) {
        IExitConfirmation result = null;
        String className = element.getAttribute(ATT_EXIT_CONFIRMATION_CLASS);
        if (className != null) {
            try {
                String contributorName = element.getContributor().getName();
                Bundle bundle = Platform.getBundle((String)contributorName);
                Class clazz = bundle.loadClass(className);
                if (!IExitConfirmation.class.isAssignableFrom(clazz)) {
                    String text = "The argument ''{0}'' must implement {1}.";
                    Object[] args = new Object[]{ATT_EXIT_CONFIRMATION_CLASS, IExitConfirmation.class.getName()};
                    String msg = MessageFormat.format(text, args);
                    throw new IllegalArgumentException(msg);
                }
                try {
                    result = (IExitConfirmation)clazz.newInstance();
                }
                catch (Exception exception) {
                    String pattern = "Can not instantiate class {0}.";
                    Object[] args = new Object[]{clazz.getName()};
                    String msg = MessageFormat.format(pattern, args);
                    throw new IllegalArgumentException(msg);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                String pattern = "Class ''{0}'' not found.";
                Object[] args = new Object[]{className};
                String msg = MessageFormat.format(pattern, args);
                throw new IllegalArgumentException(msg);
            }
        }
        return result;
    }

    private void registerDefaultServletName() {
        boolean found = false;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(EP_BRANDING);
        IConfigurationElement[] brandings = ep.getConfigurationElements();
        int i = 0;
        while (!found && i < brandings.length) {
            String servletName = brandings[i].getAttribute(ATT_SERVLET_NAME);
            if ("rap".equals(servletName)) {
                found = true;
            }
            ++i;
        }
        if (!found) {
            this.register(new AbstractBranding(){

                public String getServletName() {
                    return "rap";
                }

                public String getTitle() {
                    return "RAP Application";
                }
            });
        }
    }

    private void register(AbstractBranding branding) {
        ApplicationContext context = (ApplicationContext)((Adaptable)this.configuration).getAdapter(ApplicationContext.class);
        context.getBrandingManager().register(branding);
    }

    private void readAdditionalHeader(Branding branding, IConfigurationElement elem) {
        IConfigurationElement[] headers = elem.getChildren();
        int i = 0;
        while (i < headers.length) {
            IConfigurationElement header = headers[i];
            HashMap<String, String> attributes = new HashMap<String, String>();
            String tagName = header.getName();
            if (TAG_META.equals(tagName)) {
                attributes.put(ATT_NAME, header.getAttribute(ATT_NAME));
                attributes.put(ATT_CONTENT, header.getAttribute(ATT_CONTENT));
            } else if (TAG_LINK.equals(tagName)) {
                attributes.put(ATT_REL, header.getAttribute(ATT_REL));
                attributes.put(ATT_HREF, header.getAttribute(ATT_HREF));
            }
            IConfigurationElement[] addAttrs = header.getChildren(ELEM_ATTRIBUTE);
            int k = 0;
            while (k < addAttrs.length) {
                String name = addAttrs[k].getAttribute(ATT_NAME);
                String value = addAttrs[k].getAttribute(ATT_VALUE);
                attributes.put(name, value);
                ++k;
            }
            branding.addHeader(tagName, attributes);
            ++i;
        }
    }

    private String readBody(String contributor, String path) throws IOException {
        URL url;
        InputStream inputStream;
        String result = null;
        if (path != null && (inputStream = (url = Platform.getBundle((String)contributor).getResource(path)).openStream()) != null) {
            try {
                StringBuffer buffer = new StringBuffer();
                byte[] bytes = new byte[512];
                int bytesRead = inputStream.read(bytes);
                while (bytesRead != -1) {
                    buffer.append(new String(bytes, 0, bytesRead));
                    bytesRead = inputStream.read(bytes);
                }
                result = buffer.toString();
            }
            finally {
                inputStream.close();
            }
        }
        return result;
    }
}

