/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.scheduler;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.gyrex.common.internal.applications.BaseApplication;
import org.eclipse.gyrex.jobs.internal.JobsDebug;
import org.eclipse.gyrex.jobs.internal.scheduler.Scheduler;
import org.eclipse.gyrex.jobs.internal.util.WaitForJobToFinishJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerApplication
extends BaseApplication {
    private static final Logger LOG = LoggerFactory.getLogger(SchedulerApplication.class);
    private Scheduler scheduler;

    protected void doCleanup() {
        Scheduler scheduler = this.scheduler;
        if (scheduler != null) {
            this.scheduler = null;
            scheduler.cancel();
        }
    }

    protected void doStart(Map arguments) throws Exception {
        if (JobsDebug.schedulerEngine) {
            LOG.debug("Starting scheduler engine application.");
        }
        this.scheduler = new Scheduler();
        this.scheduler.schedule();
    }

    protected Object doStop() {
        Scheduler scheduler = this.scheduler;
        if (scheduler == null) {
            return EXIT_OK;
        }
        if (JobsDebug.schedulerEngine) {
            LOG.debug("Stopping scheduler engine application...");
        }
        this.scheduler = null;
        if (!scheduler.cancel()) {
            try {
                LOG.info("Waiting {}s for scheduler engine to finish...", (Object)30);
                CountDownLatch wait = new CountDownLatch(1);
                WaitForJobToFinishJob job = new WaitForJobToFinishJob("Scheduler Engine Shutdown Job", scheduler, wait);
                job.schedule();
                if (!wait.await(30L, TimeUnit.SECONDS)) {
                    LOG.warn("Time out waiting for scheduler engine to shutdown. A complete restart (or shutdown) of the current process is recommended.");
                    return EXIT_ERROR;
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        if (JobsDebug.schedulerEngine) {
            LOG.debug("Scheduler engine application engine stopped.");
        }
        return EXIT_OK;
    }

    protected Logger getLogger() {
        return LOG;
    }
}

