/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.http.jetty.internal;

import org.eclipse.gyrex.admin.ui.http.jetty.internal.AddChannelDialog;
import org.eclipse.gyrex.admin.ui.http.jetty.internal.ChannelsContentProvider;
import org.eclipse.gyrex.admin.ui.http.jetty.internal.JettyConfigActivator;
import org.eclipse.gyrex.admin.ui.internal.application.AdminUiUtil;
import org.eclipse.gyrex.admin.ui.internal.helper.SwtUtil;
import org.eclipse.gyrex.admin.ui.internal.widgets.Infobox;
import org.eclipse.gyrex.admin.ui.internal.widgets.NonBlockingMessageDialogs;
import org.eclipse.gyrex.http.jetty.admin.ChannelDescriptor;
import org.eclipse.gyrex.http.jetty.admin.IJettyManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.rwt.widgets.DialogCallback;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ChannelsArea {
    private ISelectionChangedListener updateButtonsListener;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private ListViewer channelsList;
    private Composite pageComposite;

    public void activate() {
        if (this.channelsList != null) {
            this.channelsList.setInput((Object)this.getJettyManager());
            this.updateButtonsListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ChannelsArea.this.updateButtons();
                }
            };
            this.channelsList.addSelectionChangedListener(this.updateButtonsListener);
        }
    }

    void addButtonPressed() {
        AddChannelDialog dialog = new AddChannelDialog(SwtUtil.getShell((Widget)this.addButton), this.getJettyManager());
        dialog.openNonBlocking(new DialogCallback(){

            public void dialogClosed(int returnCode) {
                if (returnCode == 0) {
                    ChannelsArea.this.refresh();
                }
            }
        });
    }

    private Button createButton(Composite buttons, String buttonLabel) {
        Button b = new Button(buttons, 0);
        b.setText(buttonLabel);
        b.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return b;
    }

    public void createChannelsControls(Composite parent) {
        this.pageComposite = parent;
        Infobox infobox = new Infobox(this.pageComposite);
        infobox.setLayoutData((Object)AdminUiUtil.createHorzFillData());
        infobox.addHeading("Jetty connectors in Gyrex.");
        infobox.addParagraph("Connectors are the ports Jetty listens on. When creating a connector, the port number and a name for the channel is required. Optional to that you can define the encryption settings, if the connector should support SSL.");
        Composite description = new Composite(this.pageComposite, 0);
        GridData gd = AdminUiUtil.createFillData();
        gd.verticalIndent = 10;
        description.setLayoutData((Object)gd);
        description.setLayout((Layout)AdminUiUtil.createGridLayoutWithoutMargin((int)2, (boolean)false));
        this.channelsList = new ListViewer(description, 2052);
        List list = this.channelsList.getList();
        list.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.channelsList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.channelsList.setLabelProvider((IBaseLabelProvider)new ChannelsLabelProvider());
        this.channelsList.setContentProvider((IContentProvider)new ChannelsContentProvider());
        Composite buttons = new Composite(description, 0);
        buttons.setLayoutData((Object)new GridData(4, 4, false, true));
        buttons.setLayout((Layout)new GridLayout());
        this.addButton = this.createButton(buttons, "Add");
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ChannelsArea.this.addButtonPressed();
            }
        });
        this.removeButton = this.createButton(buttons, "Remove");
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ChannelsArea.this.removeButtonPressed();
            }
        });
    }

    public void deactivate() {
        if (this.channelsList != null) {
            if (this.updateButtonsListener != null) {
                this.channelsList.removeSelectionChangedListener(this.updateButtonsListener);
                this.updateButtonsListener = null;
            }
            if (!this.channelsList.getList().isDisposed()) {
                this.channelsList.setInput(null);
            }
        }
    }

    private IJettyManager getJettyManager() {
        return JettyConfigActivator.getInstance().getJettyManager();
    }

    private ChannelDescriptor getSelectedChannel() {
        IStructuredSelection selection = (IStructuredSelection)this.channelsList.getSelection();
        if (!selection.isEmpty() && selection.getFirstElement() instanceof ChannelDescriptor) {
            return (ChannelDescriptor)selection.getFirstElement();
        }
        return null;
    }

    public void refresh() {
        this.channelsList.refresh();
        this.updateButtons();
    }

    void removeButtonPressed() {
        final ChannelDescriptor channel = this.getSelectedChannel();
        if (channel == null) {
            return;
        }
        NonBlockingMessageDialogs.openQuestion((Shell)SwtUtil.getShell((Widget)this.pageComposite), (String)"Remove selected Channel", (String)String.format("Do you really want to delete channel %s?", channel.getId()), (DialogCallback)new DialogCallback(){

            public void dialogClosed(int returnCode) {
                if (returnCode != 0) {
                    return;
                }
                ChannelsArea.this.getJettyManager().removeChannel(channel.getId());
                ChannelsArea.this.refresh();
            }
        });
    }

    void updateButtons() {
        int selectedElementsCount = ((IStructuredSelection)this.channelsList.getSelection()).size();
        if (selectedElementsCount == 0) {
            this.addButton.setEnabled(true);
            this.removeButton.setEnabled(false);
            return;
        }
        this.addButton.setEnabled(selectedElementsCount == 1);
        this.removeButton.setEnabled(selectedElementsCount == 1);
    }

    static class ChannelsLabelProvider
    extends LabelProvider {
        ChannelsLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ChannelDescriptor) {
                ChannelDescriptor channel = (ChannelDescriptor)element;
                return String.format("%s (%d)", channel.getId(), channel.getPort());
            }
            return super.getText(element);
        }
    }
}

