/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.lifecycle;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.branding.AbstractBranding;
import org.eclipse.rwt.internal.application.RWTFactory;
import org.eclipse.rwt.internal.branding.BrandingUtil;
import org.eclipse.rwt.internal.lifecycle.EntryPointManager;
import org.eclipse.rwt.internal.lifecycle.EntryPointRegistration;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.lifecycle.IEntryPoint;
import org.eclipse.rwt.lifecycle.IEntryPointFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryPointUtil {
    public static final String DEFAULT = "default";

    private EntryPointUtil() {
    }

    public static IEntryPoint getCurrentEntryPoint() {
        EntryPointRegistration registration = EntryPointUtil.findCurrentEntryPointRegistration();
        return registration.getFactory().create();
    }

    public static Map<String, String> getCurrentEntryPointProperties() {
        EntryPointRegistration registration = EntryPointUtil.findCurrentEntryPointRegistration();
        return registration.getProperties();
    }

    private static EntryPointRegistration findCurrentEntryPointRegistration() {
        EntryPointRegistration result = EntryPointUtil.findByStartupParameter();
        if (result == null && (result = EntryPointUtil.findByServletPath()) == null && (result = EntryPointUtil.findByBranding()) == null) {
            result = EntryPointUtil.getEntryPointByName(DEFAULT);
        }
        return result;
    }

    private static EntryPointRegistration findByStartupParameter() {
        EntryPointRegistration result = null;
        HttpServletRequest request = ContextProvider.getRequest();
        String name = request.getParameter("startup");
        if (name != null && name.length() > 0) {
            result = EntryPointUtil.getEntryPointByName(name);
        }
        return result;
    }

    private static EntryPointRegistration findByServletPath() {
        EntryPointRegistration result = null;
        HttpServletRequest request = ContextProvider.getRequest();
        String path = request.getServletPath();
        if (path != null && path.length() > 0) {
            EntryPointManager entryPointManager = RWTFactory.getEntryPointManager();
            result = entryPointManager.getRegistrationByPath(path);
        }
        return result;
    }

    private static EntryPointRegistration findByBranding() {
        EntryPointRegistration result = null;
        AbstractBranding branding = BrandingUtil.determineBranding();
        String name = branding.getDefaultEntryPoint();
        if (name != null && name.length() > 0) {
            result = EntryPointUtil.getEntryPointByName(name);
        }
        return result;
    }

    private static EntryPointRegistration getEntryPointByName(String name) {
        EntryPointManager entryPointManager = RWTFactory.getEntryPointManager();
        IEntryPointFactory factory = entryPointManager.getFactoryByName(name);
        if (factory == null) {
            throw new IllegalArgumentException("Entry point not found: " + name);
        }
        return new EntryPointRegistration(factory, null);
    }
}

