/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.zk.console;

import java.util.List;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.eclipse.gyrex.cloud.internal.zk.console.RecursivePathBasedCmd;

public class RmPathCmd
extends RecursivePathBasedCmd {
    public RmPathCmd() {
        super("- removes the specified path");
    }

    private void deleteTree(ZooKeeper zk, String path) throws InterruptedException, KeeperException {
        List children = zk.getChildren(path.toString(), false);
        for (String child : children) {
            this.deleteTree(zk, String.valueOf(path) + (path.equals("/") ? "" : "/") + child);
        }
        zk.delete(path, -1);
    }

    @Override
    protected void doExecute(ZooKeeper zk, String path) throws Exception {
        if (this.recursive) {
            this.deleteTree(zk, path);
        } else {
            zk.delete(path, -1);
        }
        this.printf("Removed %s", new Object[]{path});
    }
}

