/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.http.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.admin.ui.adapter.AdapterUtil;
import org.eclipse.gyrex.admin.ui.adapter.LabelAdapter;
import org.eclipse.gyrex.admin.ui.http.internal.ApplicationBrowserComparator;
import org.eclipse.gyrex.admin.ui.http.internal.ApplicationBrowserContentProvider;
import org.eclipse.gyrex.admin.ui.http.internal.ApplicationPatternFilter;
import org.eclipse.gyrex.admin.ui.http.internal.EditApplicationDialog;
import org.eclipse.gyrex.admin.ui.http.internal.HttpUiActivator;
import org.eclipse.gyrex.admin.ui.http.internal.HttpUiAdapter;
import org.eclipse.gyrex.admin.ui.internal.application.AdminUiUtil;
import org.eclipse.gyrex.admin.ui.internal.helper.SwtUtil;
import org.eclipse.gyrex.admin.ui.internal.widgets.Infobox;
import org.eclipse.gyrex.admin.ui.internal.widgets.NonBlockingMessageDialogs;
import org.eclipse.gyrex.admin.ui.pages.FilteredAdminPage;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationManager;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationRegistration;
import org.eclipse.gyrex.server.Platform;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.rwt.widgets.DialogCallback;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class HttpApplicationPage
extends FilteredAdminPage {
    private static final String FILTER_PROVIDER = "applicationProvider";
    private static final String FILTER_CONTEXT = "context";
    private Composite pageComposite;
    private TreeViewer treeViewer;
    private Button editButton;
    private Button addButton;
    private Button removeButton;
    private Button activateButton;
    private Button deactivateButton;
    private ISelectionChangedListener updateButtonsListener;

    public HttpApplicationPage() {
        this.setTitle("Manage Web Applications");
        this.setTitleToolTip("Define, configure and mount applications.");
    }

    public void activate() {
        super.activate();
        if (this.treeViewer != null) {
            this.treeViewer.setInput((Object)this.getApplicationManager());
            this.updateButtonsListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    HttpApplicationPage.this.updateButtons();
                }
            };
            this.treeViewer.addSelectionChangedListener(this.updateButtonsListener);
            this.treeViewer.getControl().getDisplay();
            this.treeViewer.expandAll();
        }
    }

    void activateSelectedApplications() {
        List<ApplicationBrowserContentProvider.ApplicationItem> selectedAppRegs = this.getSelectedAppRegs();
        for (ApplicationBrowserContentProvider.ApplicationItem appRegItem : selectedAppRegs) {
            ApplicationRegistration app = appRegItem.getApplicationRegistration();
            this.getApplicationManager().activate(app.getApplicationId());
        }
        this.refresh();
    }

    void addButtonPressed() {
        EditApplicationDialog dialog = new EditApplicationDialog(SwtUtil.getShell((Widget)this.addButton), this.getApplicationManager(), null);
        dialog.openNonBlocking(new DialogCallback(){

            public void dialogClosed(int returnCode) {
                if (returnCode == 0) {
                    HttpApplicationPage.this.refresh();
                }
            }
        });
    }

    private FilteredTree createApplicationBrowser(Composite parent) {
        FilteredTree filteredTree = new FilteredTree(parent, 67586, (PatternFilter)new ApplicationPatternFilter(), true);
        this.treeViewer = filteredTree.getViewer();
        this.treeViewer.getTree().setHeaderVisible(true);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 40));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, 20));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 20));
        this.treeViewer.getTree().setLayout((Layout)layout);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setContentProvider((IContentProvider)new ApplicationBrowserContentProvider());
        ApplicationBrowserComparator comparator = new ApplicationBrowserComparator();
        this.treeViewer.setComparator((ViewerComparator)comparator);
        this.treeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                HttpApplicationPage.this.editSelectedApplication();
            }
        });
        final Image activeApplication = HttpUiActivator.getImageDescriptor("icons/obj/app_active.gif").createImage((Device)parent.getDisplay());
        final Image inactiveApplication = HttpUiActivator.getImageDescriptor("icons/obj/app_inactive.gif").createImage((Device)parent.getDisplay());
        TreeViewerColumn idColumn = new TreeViewerColumn(this.treeViewer, 16384);
        idColumn.getColumn().setText("Instance ID");
        idColumn.getColumn().addSelectionListener((SelectionListener)new ApplicationBrowserSortListener(comparator, ApplicationBrowserComparator.SortIndex.ID, idColumn));
        idColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public void dispose() {
                super.dispose();
                activeApplication.dispose();
                inactiveApplication.dispose();
            }

            public Image getImage(Object element) {
                if (element instanceof ApplicationBrowserContentProvider.ApplicationItem) {
                    ApplicationBrowserContentProvider.ApplicationItem appItem = (ApplicationBrowserContentProvider.ApplicationItem)element;
                    if (appItem.isActive()) {
                        return activeApplication;
                    }
                    return inactiveApplication;
                }
                return super.getImage(element);
            }

            public String getText(Object element) {
                if (element instanceof ApplicationBrowserContentProvider.ApplicationItem) {
                    return ((ApplicationBrowserContentProvider.ApplicationItem)element).getApplicationId();
                }
                if (element instanceof ApplicationBrowserContentProvider.GroupNode) {
                    Object value = ((ApplicationBrowserContentProvider.GroupNode)element).getValue();
                    LabelAdapter adapter = (LabelAdapter)AdapterUtil.getAdapter((Object)value, LabelAdapter.class);
                    if (adapter != null) {
                        return adapter.getLabel(value);
                    }
                    return String.valueOf(value);
                }
                return String.valueOf(element);
            }
        });
        this.treeViewer.getTree().setSortColumn(idColumn.getColumn());
        this.treeViewer.getTree().setSortDirection(comparator.isReverse() ? 128 : 1024);
        TreeViewerColumn providerColumn = new TreeViewerColumn(this.treeViewer, 16384);
        providerColumn.getColumn().setText("Type");
        providerColumn.getColumn().addSelectionListener((SelectionListener)new ApplicationBrowserSortListener(comparator, ApplicationBrowserComparator.SortIndex.PROVIDER_ID, providerColumn));
        providerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ApplicationBrowserContentProvider.ApplicationItem) {
                    return HttpUiAdapter.getLabel(((ApplicationBrowserContentProvider.ApplicationItem)element).getApplicationProviderRegistration());
                }
                return null;
            }
        });
        TreeViewerColumn mountsColumn = new TreeViewerColumn(this.treeViewer, 16384);
        mountsColumn.getColumn().setText("Mounts");
        mountsColumn.getColumn().addSelectionListener((SelectionListener)new ApplicationBrowserSortListener(comparator, ApplicationBrowserComparator.SortIndex.MOUNTS, mountsColumn));
        mountsColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ApplicationBrowserContentProvider.ApplicationItem) {
                    return StringUtils.join(((ApplicationBrowserContentProvider.ApplicationItem)element).getMounts(), (String)", ");
                }
                return null;
            }
        });
        return filteredTree;
    }

    private Button createButton(Composite buttons, String buttonLabel) {
        Button b = new Button(buttons, 0);
        b.setText(buttonLabel);
        b.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return b;
    }

    public Control createControl(Composite parent) {
        this.pageComposite = new Composite(parent, 0);
        this.pageComposite.setLayout((Layout)AdminUiUtil.createGridLayoutWithoutMargin((int)1, (boolean)false));
        if (Platform.inDevelopmentMode()) {
            Infobox infobox = new Infobox(this.pageComposite);
            infobox.setLayoutData((Object)AdminUiUtil.createHorzFillData());
            infobox.addHeading("Web Applications in Gyrex.");
            infobox.addParagraph("In OSGi the HttpService is the prefered way of making Servlets and resources available. Out of the box (in development only) an HttpService is also available in Gyrex. However, that approache does not scale very well in a multi-tenant environment. Therefore, Gyrex allows to develop and integrate multiple kind of web applications. The OSGi HttpService is just one available example of a web application. It's possible to <a href=\"http://wiki.eclipse.org/Gyrex/Developer_Guide/Web_Applications\">develop your own applications</a>.");
            infobox.addParagraph("In order to make a new application accessible an instance need to be defined first and then it needs to be mounted to an URL.");
        }
        Composite description = new Composite(this.pageComposite, 0);
        GridData gd = AdminUiUtil.createFillData();
        gd.verticalIndent = 10;
        description.setLayoutData((Object)gd);
        description.setLayout((Layout)AdminUiUtil.createGridLayoutWithoutMargin((int)2, (boolean)false));
        FilteredTree filteredTree = this.createApplicationBrowser(description);
        filteredTree.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite buttons = new Composite(description, 0);
        buttons.setLayoutData((Object)new GridData(4, 4, false, true));
        buttons.setLayout((Layout)new GridLayout());
        this.addButton = this.createButton(buttons, "Add");
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                HttpApplicationPage.this.addButtonPressed();
            }
        });
        this.editButton = this.createButton(buttons, "Edit");
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                HttpApplicationPage.this.editSelectedApplication();
            }
        });
        this.removeButton = this.createButton(buttons, "Remove");
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                HttpApplicationPage.this.removeSelectedApplication();
            }
        });
        Label label = new Label(buttons, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.activateButton = this.createButton(buttons, "Activate");
        this.activateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                HttpApplicationPage.this.activateSelectedApplications();
            }
        });
        this.deactivateButton = this.createButton(buttons, "Deactivate");
        this.deactivateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                HttpApplicationPage.this.deactivateSelectedApplications();
            }
        });
        this.updateButtons();
        return this.pageComposite;
    }

    public void deactivate() {
        super.deactivate();
        if (this.treeViewer != null) {
            if (this.updateButtonsListener != null) {
                this.treeViewer.removeSelectionChangedListener(this.updateButtonsListener);
                this.updateButtonsListener = null;
            }
            if (!this.treeViewer.getTree().isDisposed()) {
                this.treeViewer.setInput(null);
            }
        }
    }

    void deactivateSelectedApplications() {
        List<ApplicationBrowserContentProvider.ApplicationItem> selectedAppRegs = this.getSelectedAppRegs();
        for (ApplicationBrowserContentProvider.ApplicationItem appRegItem : selectedAppRegs) {
            ApplicationRegistration app = appRegItem.getApplicationRegistration();
            this.getApplicationManager().deactivate(app.getApplicationId());
        }
        this.refresh();
    }

    void editSelectedApplication() {
        if (this.getSelectedValue() == null) {
            return;
        }
        ApplicationRegistration app = this.getSelectedValue().getApplicationRegistration();
        EditApplicationDialog dialog = new EditApplicationDialog(SwtUtil.getShell((Widget)this.editButton), this.getApplicationManager(), app);
        dialog.openNonBlocking(new DialogCallback(){

            public void dialogClosed(int returnCode) {
                if (returnCode == 0) {
                    HttpApplicationPage.this.refresh();
                }
            }
        });
    }

    private ApplicationManager getApplicationManager() {
        return HttpUiActivator.getAppManager();
    }

    protected String getFilterText(String filter) {
        if (FILTER_CONTEXT.equals(filter)) {
            return "All Contexts";
        }
        if (FILTER_PROVIDER.equals(filter)) {
            return "All Applications";
        }
        return super.getFilterText(filter);
    }

    private List<ApplicationBrowserContentProvider.ApplicationItem> getSelectedAppRegs() {
        ArrayList<ApplicationBrowserContentProvider.ApplicationItem> selectedOnes = new ArrayList<ApplicationBrowserContentProvider.ApplicationItem>();
        TreeSelection selection = (TreeSelection)this.treeViewer.getSelection();
        for (Object element : selection) {
            if (!(element instanceof ApplicationBrowserContentProvider.ApplicationItem)) continue;
            selectedOnes.add((ApplicationBrowserContentProvider.ApplicationItem)element);
        }
        return selectedOnes;
    }

    private ApplicationBrowserContentProvider.ApplicationItem getSelectedValue() {
        TreeSelection selection = (TreeSelection)this.treeViewer.getSelection();
        if (!selection.isEmpty() && selection.getFirstElement() instanceof ApplicationBrowserContentProvider.ApplicationItem) {
            return (ApplicationBrowserContentProvider.ApplicationItem)selection.getFirstElement();
        }
        return null;
    }

    void refresh() {
        this.treeViewer.refresh();
        this.treeViewer.expandAll();
    }

    void removeSelectedApplication() {
        final ApplicationBrowserContentProvider.ApplicationItem applicationItem = this.getSelectedValue();
        if (applicationItem == null) {
            return;
        }
        NonBlockingMessageDialogs.openQuestion((Shell)SwtUtil.getShell((Widget)this.pageComposite), (String)"Remove Application", (String)String.format("Do you really want to delete instance %s?", applicationItem.getApplicationId()), (DialogCallback)new DialogCallback(){

            public void dialogClosed(int returnCode) {
                if (returnCode != 0) {
                    return;
                }
                HttpApplicationPage.this.getApplicationManager().unregister(applicationItem.getApplicationId());
                HttpApplicationPage.this.refresh();
            }
        });
    }

    void updateButtons() {
        int selectedElementsCount = ((IStructuredSelection)this.treeViewer.getSelection()).size();
        if (selectedElementsCount == 0) {
            this.activateButton.setEnabled(false);
            this.deactivateButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            return;
        }
        boolean hasActiveApps = false;
        boolean hasInactiveApps = false;
        for (Object object : (IStructuredSelection)this.treeViewer.getSelection()) {
            if (object instanceof ApplicationBrowserContentProvider.ApplicationItem) {
                ApplicationBrowserContentProvider.ApplicationItem nodeItem = (ApplicationBrowserContentProvider.ApplicationItem)object;
                hasActiveApps |= nodeItem.isActive();
                hasInactiveApps |= !nodeItem.isActive();
            }
            if (hasInactiveApps && hasActiveApps) break;
        }
        this.activateButton.setEnabled(hasInactiveApps);
        this.deactivateButton.setEnabled(hasActiveApps);
        this.editButton.setEnabled(selectedElementsCount == 1);
        this.removeButton.setEnabled(selectedElementsCount == 1);
    }

    private final class ApplicationBrowserSortListener
    extends SelectionAdapter {
        private final ApplicationBrowserComparator comparator;
        private final TreeViewerColumn column;
        private final ApplicationBrowserComparator.SortIndex sortIndex;

        private ApplicationBrowserSortListener(ApplicationBrowserComparator comparator, ApplicationBrowserComparator.SortIndex sortIndex, TreeViewerColumn column) {
            this.comparator = comparator;
            this.sortIndex = sortIndex;
            this.column = column;
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.comparator.getIndex() == this.sortIndex) {
                this.comparator.setReverse(!this.comparator.isReverse());
            } else {
                this.comparator.setIndex(this.sortIndex);
                HttpApplicationPage.this.treeViewer.getTree().setSortColumn(this.column.getColumn());
            }
            HttpApplicationPage.this.treeViewer.getTree().setSortDirection(this.comparator.isReverse() ? 128 : 1024);
            HttpApplicationPage.this.treeViewer.refresh();
            HttpApplicationPage.this.treeViewer.expandAll();
        }
    }
}

