/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.manager;

import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.cloud.services.locking.IExclusiveLock;
import org.eclipse.gyrex.jobs.JobState;
import org.eclipse.gyrex.jobs.internal.JobsDebug;
import org.eclipse.gyrex.jobs.internal.manager.JobHistoryStore;
import org.eclipse.gyrex.jobs.internal.manager.JobHungDetectionHelper;
import org.eclipse.gyrex.jobs.internal.manager.JobImpl;
import org.eclipse.gyrex.jobs.internal.manager.JobManagerImpl;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CleanupJob
extends Job {
    private static final Logger LOG = LoggerFactory.getLogger(CleanupJob.class);
    private final long maxAge;

    public CleanupJob() {
        super("Gyrex Job API Garbage Collector");
        this.setSystem(true);
        this.setPriority(30);
        this.setRule(new MutexRule(CleanupJob.class));
        int maxDaysSinceLastRun = Integer.getInteger("gyrex.jobs.cleanup.maxDaysSinceLastRun", 30);
        this.maxAge = maxDaysSinceLastRun > 0 ? TimeUnit.DAYS.toMillis(maxDaysSinceLastRun) : Long.MAX_VALUE;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IEclipsePreferences jobsNode = JobHistoryStore.getJobsNode();
        try {
            String[] childrenNames;
            LOG.info("Refreshing job definitions...");
            jobsNode.sync();
            LOG.info("Cleaning up old job definitions...");
            long now = System.currentTimeMillis();
            String[] stringArray = childrenNames = jobsNode.childrenNames();
            int n = childrenNames.length;
            int n2 = 0;
            while (n2 < n) {
                String internalId = stringArray[n2];
                String externalId = JobManagerImpl.getExternalId(internalId);
                JobImpl job = JobManagerImpl.readJob(externalId, jobsNode.node(internalId));
                IExclusiveLock lock = JobManagerImpl.acquireLock(job);
                try {
                    job = JobManagerImpl.readJob(externalId, jobsNode.node(internalId));
                    if (JobHungDetectionHelper.isStuck(internalId, job, true)) {
                        LOG.info("Resetting job {} stuck in state {} (queued {} minutes and started {} minutes ago).", new Object[]{job.getId(), job.getState(), TimeUnit.MILLISECONDS.toMinutes(System.currentTimeMillis() - job.getLastQueued()), TimeUnit.MILLISECONDS.toMinutes(System.currentTimeMillis() - job.getLastStart())});
                        Preferences jobNode = jobsNode.node(internalId);
                        jobNode.put("status", JobState.NONE.name());
                        jobNode.remove("active");
                        jobNode.flush();
                        job = JobManagerImpl.readJob(externalId, jobsNode.node(internalId));
                    }
                    if (job.getState() != JobState.NONE) {
                        if (JobsDebug.cleanup) {
                            LOG.debug("Skipping active job {}...", (Object)job.getId());
                        }
                    } else {
                        long jobAge = now - Math.max(job.getLastResultTimestamp(), Math.max(job.getLastQueued(), job.getLastStart()));
                        if (jobAge < this.maxAge) {
                            if (JobsDebug.cleanup) {
                                LOG.debug("Skipping too young job {} (age {} days)...", (Object)job.getId(), (Object)TimeUnit.MILLISECONDS.toDays(jobAge));
                            }
                        } else {
                            LOG.info("Removing job {}.", (Object)externalId);
                            if (jobsNode.nodeExists(internalId)) {
                                jobsNode.node(internalId).removeNode();
                                jobsNode.flush();
                            }
                        }
                    }
                }
                finally {
                    lock.release();
                }
                ++n2;
            }
            LOG.info("Finished clean-up of old job definitions.");
        }
        catch (Exception e) {
            LOG.warn("Unable to clean-up old job definitions. {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    static class MutexRule
    implements ISchedulingRule {
        private final Object object;

        public MutexRule(Object object) {
            this.object = object;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            if (rule instanceof MutexRule) {
                return this.object.equals(((MutexRule)rule).object);
            }
            return false;
        }
    }
}

