/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.application;

import java.util.List;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public abstract class DropDownMenu
extends Composite {
    private static final long serialVersionUID = 1L;
    private final Menu pullDownMenu;
    private final String text;
    private final String customVariant;
    private final ToolBar toolBar;
    private final ToolItem toolItem;
    private boolean selected;
    private boolean open;

    public DropDownMenu(Composite parent, String text, String customVariant) {
        super(parent, 0);
        this.text = text;
        this.customVariant = customVariant;
        this.pullDownMenu = this.createMenu(parent);
        this.setLayout((Layout)new FillLayout());
        this.setLayoutData(new GridData(16384, 0x1000000, true, false));
        this.toolBar = new ToolBar((Composite)this, 256);
        this.toolBar.setData("org.eclipse.rwt.themeVariant", (Object)customVariant);
        this.toolItem = new ToolItem(this.toolBar, 4);
        this.toolItem.setData("org.eclipse.rwt.themeVariant", (Object)customVariant);
        this.toolItem.setText(text.replace("&", "&&"));
        this.toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DropDownMenu.this.toolItemSelected(DropDownMenu.this.toolBar, event);
            }
        });
    }

    private Menu createMenu(Composite parent) {
        Menu menu = new Menu((Decorations)parent.getShell(), 8);
        menu.setData("org.eclipse.rwt.themeVariant", (Object)this.customVariant);
        return menu;
    }

    private void createMenuItem(final String item) {
        MenuItem menuItem = new MenuItem(this.pullDownMenu, 16392);
        menuItem.setText(item.replace("&", "&&"));
        menuItem.setData("org.eclipse.rwt.themeVariant", (Object)this.customVariant);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DropDownMenu.this.openItem(item);
            }
        });
    }

    public void createMenuItems(List<String> items) {
        MenuItem[] menuItemArray = this.pullDownMenu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem menuItem = menuItemArray[n2];
            menuItem.dispose();
            ++n2;
        }
        for (String item : items) {
            this.createMenuItem(item);
        }
    }

    public String getText() {
        return this.text;
    }

    public ToolItem getToolItem() {
        return this.toolItem;
    }

    protected abstract void openItem(String var1);

    private void openMenu(Point point) {
        this.setOpen(true);
        this.pullDownMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuHidden(MenuEvent e) {
                DropDownMenu.this.setOpen(false);
                DropDownMenu.this.pullDownMenu.removeMenuListener((MenuListener)this);
            }
        });
        this.pullDownMenu.setLocation(point);
        this.pullDownMenu.setVisible(true);
    }

    public void setOpen(boolean open) {
        this.open = open;
        this.updateCustomVariant();
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.updateCustomVariant();
    }

    void toolItemSelected(ToolBar toolBar, SelectionEvent event) {
        if (this.pullDownMenu.getItemCount() == 0) {
            return;
        }
        Rectangle pos = ((ToolItem)event.getSource()).getBounds();
        this.openMenu(toolBar.toDisplay(pos.x, pos.y + pos.height));
    }

    private void updateCustomVariant() {
        String variant = this.customVariant;
        if (this.selected) {
            variant = String.valueOf(variant) + "Selected";
        }
        if (this.open) {
            variant = String.valueOf(variant) + "Open";
        }
        this.toolItem.setData("org.eclipse.rwt.themeVariant", (Object)variant);
    }
}

