/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.cloud.internal;

import java.util.Collection;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.gyrex.admin.ui.cloud.internal.CloudUiActivator;
import org.eclipse.gyrex.admin.ui.cloud.internal.ConnectToCloudDialog;
import org.eclipse.gyrex.admin.ui.cloud.internal.EditNodeDialog;
import org.eclipse.gyrex.admin.ui.cloud.internal.NodeBrowserComparator;
import org.eclipse.gyrex.admin.ui.cloud.internal.NodeBrowserContentProvider;
import org.eclipse.gyrex.admin.ui.cloud.internal.NodePatternFilter;
import org.eclipse.gyrex.admin.ui.internal.application.AdminUiUtil;
import org.eclipse.gyrex.admin.ui.internal.helper.SwtUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.LinkDialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.gyrex.admin.ui.pages.AdminPage;
import org.eclipse.gyrex.cloud.admin.ICloudManager;
import org.eclipse.gyrex.cloud.admin.INodeConfigurer;
import org.eclipse.gyrex.cloud.environment.INodeEnvironment;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGate;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGateListener;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.rwt.widgets.DialogCallback;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class ClusterAdminPage
extends AdminPage {
    private ZooKeeperGateListener listener;
    private StringDialogField nodeIdField;
    private LinkDialogField membershipStatusField;
    private Composite composite;
    private TreeViewer treeViewer;
    private Button approveButton;
    private Button retireButton;
    private Button editButton;
    private ISelectionChangedListener updateButtonsListener;

    public ClusterAdminPage() {
        this.setTitle("Cluster Configuration");
        this.setTitleToolTip("Configure the cluster of nodes in the system.");
    }

    public void activate() {
        Display display;
        super.activate();
        if (this.treeViewer != null) {
            this.treeViewer.setInput((Object)this.getCloudManager());
            this.updateButtonsListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ClusterAdminPage.this.updateButtons();
                }
            };
            this.treeViewer.addSelectionChangedListener(this.updateButtonsListener);
            display = this.treeViewer.getControl().getDisplay();
        } else {
            display = null;
        }
        if (this.listener == null && display != null && !display.isDisposed()) {
            this.listener = new ZooKeeperGateListener(){

                private void asyncRefresh() {
                    if (!display.isDisposed()) {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ClusterAdminPage.this.refresh();
                            }
                        });
                    }
                }

                public void gateDown(ZooKeeperGate gate) {
                    this.asyncRefresh();
                }

                public void gateRecovering(ZooKeeperGate gate) {
                    this.asyncRefresh();
                }

                public void gateUp(ZooKeeperGate gate) {
                    this.asyncRefresh();
                }
            };
            ZooKeeperGate.addConnectionMonitor((ZooKeeperGateListener)this.listener);
        }
        this.refresh();
    }

    void approveSelectedNodes() {
        ICloudManager cloudManager = this.getCloudManager();
        MultiStatus result = new MultiStatus("org.eclipse.gyrex.admin.ui.cloud", 0, "Some nodes could not be approved.", null);
        for (Object object : (IStructuredSelection)this.treeViewer.getSelection()) {
            IStatus status;
            NodeBrowserContentProvider.NodeItem nodeItem;
            if (!(object instanceof NodeBrowserContentProvider.NodeItem) || (nodeItem = (NodeBrowserContentProvider.NodeItem)object).isApproved() || (status = cloudManager.approveNode(nodeItem.getDescriptor().getId())).isOK()) continue;
            result.add(status);
        }
        if (!result.isOK()) {
            Policy.getStatusHandler().show((IStatus)result, "Error");
        }
    }

    private void createButtons(Composite parent) {
        this.approveButton = new Button(parent, 8);
        this.approveButton.setText("Approve");
        this.approveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClusterAdminPage.this.approveSelectedNodes();
            }
        });
        this.retireButton = new Button(parent, 8);
        this.retireButton.setText("Retire");
        this.retireButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClusterAdminPage.this.retireSelectedNodes();
            }
        });
        this.createButtonSeparator(parent);
        this.editButton = new Button(parent, 8);
        this.editButton.setText("Edit");
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClusterAdminPage.this.editSelectedNode();
            }
        });
    }

    private Label createButtonSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        separator.setVisible(false);
        RowData gd = new RowData();
        gd.height = 4;
        separator.setLayoutData((Object)gd);
        return separator;
    }

    private Control createConnectGroup(Composite parent) {
        Composite connectGroup = new Composite(parent, 0);
        GridLayout innerLayout = new GridLayout();
        innerLayout.numColumns = 2;
        innerLayout.marginWidth = 0;
        innerLayout.marginHeight = 0;
        connectGroup.setLayout((Layout)innerLayout);
        this.nodeIdField = new StringDialogField(){

            protected Text createTextControl(Composite parent) {
                return new Text(parent, 12);
            }
        };
        this.nodeIdField.setLabelText("Node Id:");
        this.membershipStatusField = new LinkDialogField();
        this.membershipStatusField.setLabelText("Status:");
        LayoutUtil.doDefaultLayout((Composite)connectGroup, (DialogField[])new DialogField[]{this.nodeIdField, this.membershipStatusField}, (boolean)false);
        LayoutUtil.setHorizontalGrabbing((Control)this.nodeIdField.getTextControl(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.membershipStatusField.getLinkControl(null));
        int heightHint = this.membershipStatusField.getLabelControl(null).computeSize((int)-1, (int)-1).y;
        LayoutUtil.setHeightHint((Control)this.membershipStatusField.getLabelControl(null), (int)heightHint);
        LayoutUtil.setHeightHint((Control)this.membershipStatusField.getLinkControl(null), (int)heightHint);
        this.membershipStatusField.getLinkControl(null).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if ("#connect".equals(e.text)) {
                    ClusterAdminPage.this.showConnectDialog();
                } else if ("#disconnect".equals(e.text)) {
                    ClusterAdminPage.this.disconnectNode();
                }
            }
        });
        return connectGroup;
    }

    public Control createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)AdminUiUtil.createGridLayoutWithoutMargin((int)1, (boolean)false));
        Control connectGroup = this.createConnectGroup(this.composite);
        GridData gd = AdminUiUtil.createHorzFillData();
        gd.verticalIndent = 10;
        connectGroup.setLayoutData((Object)gd);
        Composite description = new Composite(this.composite, 0);
        gd = AdminUiUtil.createFillData();
        gd.verticalIndent = 10;
        description.setLayoutData((Object)gd);
        description.setLayout((Layout)AdminUiUtil.createGridLayoutWithoutMargin((int)2, (boolean)false));
        FilteredTree filteredTree = this.createNodeBrowser(description);
        filteredTree.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite buttons = new Composite(description, 0);
        buttons.setLayoutData((Object)new GridData(1, 4, false, true));
        buttons.setLayout((Layout)new RowLayout(512));
        this.createButtons(buttons);
        return this.composite;
    }

    private FilteredTree createNodeBrowser(Composite parent) {
        FilteredTree filteredTree = new FilteredTree(parent, 67586, (PatternFilter)new NodePatternFilter(), true);
        this.treeViewer = filteredTree.getViewer();
        this.treeViewer.getTree().setHeaderVisible(true);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 50));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 50));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(60, 50));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, 50));
        this.treeViewer.getTree().setLayout((Layout)layout);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setContentProvider((IContentProvider)new NodeBrowserContentProvider());
        NodeBrowserComparator comparator = new NodeBrowserComparator();
        this.treeViewer.setComparator((ViewerComparator)comparator);
        this.treeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ClusterAdminPage.this.editSelectedNode();
            }
        });
        TreeViewerColumn idColumn = new TreeViewerColumn(this.treeViewer, 16384);
        idColumn.getColumn().setText("Node ID");
        idColumn.getColumn().addSelectionListener((SelectionListener)new NodeBrowserSortListener(comparator, NodeBrowserComparator.SortIndex.ID, idColumn));
        idColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof NodeBrowserContentProvider.NodeItem) {
                    return ((NodeBrowserContentProvider.NodeItem)element).getDescriptor().getId();
                }
                return String.valueOf(element);
            }
        });
        this.treeViewer.getTree().setSortColumn(idColumn.getColumn());
        this.treeViewer.getTree().setSortDirection(comparator.isReverse() ? 128 : 1024);
        TreeViewerColumn locationColumn = new TreeViewerColumn(this.treeViewer, 16384);
        locationColumn.getColumn().setText("Location");
        locationColumn.getColumn().addSelectionListener((SelectionListener)new NodeBrowserSortListener(comparator, NodeBrowserComparator.SortIndex.LOCATION, locationColumn));
        locationColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof NodeBrowserContentProvider.NodeItem) {
                    return ((NodeBrowserContentProvider.NodeItem)element).getDescriptor().getLocation();
                }
                return null;
            }
        });
        TreeViewerColumn tagsColumn = new TreeViewerColumn(this.treeViewer, 16384);
        tagsColumn.getColumn().setText("Tags");
        tagsColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof NodeBrowserContentProvider.NodeItem) {
                    return StringUtils.join((Collection)((NodeBrowserContentProvider.NodeItem)element).getDescriptor().getTags(), (String)", ");
                }
                return null;
            }
        });
        TreeViewerColumn statusColumn = new TreeViewerColumn(this.treeViewer, 16384);
        statusColumn.getColumn().setText("Status");
        statusColumn.getColumn().addSelectionListener((SelectionListener)new NodeBrowserSortListener(comparator, NodeBrowserComparator.SortIndex.STATUS, statusColumn));
        statusColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof NodeBrowserContentProvider.NodeItem) {
                    NodeBrowserContentProvider.NodeItem nodeItem = (NodeBrowserContentProvider.NodeItem)element;
                    StrBuilder status = new StrBuilder();
                    if (nodeItem.isApproved()) {
                        status.append("approved");
                    } else {
                        status.append("pending");
                    }
                    if (nodeItem.isOnline()) {
                        status.appendSeparator(", ").append("online");
                    }
                    return status.toString();
                }
                return null;
            }
        });
        return filteredTree;
    }

    public void deactivate() {
        super.deactivate();
        if (this.treeViewer != null) {
            if (this.updateButtonsListener != null) {
                this.treeViewer.removeSelectionChangedListener(this.updateButtonsListener);
                this.updateButtonsListener = null;
            }
            if (this.treeViewer.getTree().isDisposed()) {
                this.treeViewer.setInput(null);
            }
        }
        if (this.listener != null) {
            ZooKeeperGate.removeConnectionMonitor((ZooKeeperGateListener)this.listener);
            this.listener = null;
        }
    }

    void disconnectNode() {
        ICloudManager cloudManager = this.getCloudManager();
        INodeConfigurer nodeConfigurer = cloudManager.getNodeConfigurer(cloudManager.getLocalInfo().getNodeId());
        IStatus status = nodeConfigurer.configureConnection(null);
        if (!status.isOK()) {
            Policy.getStatusHandler().show(status, "Error Disconnecting Node");
            return;
        }
        this.refresh();
    }

    void editSelectedNode() {
        Object firstElement = ((IStructuredSelection)this.treeViewer.getSelection()).getFirstElement();
        if (!(firstElement instanceof NodeBrowserContentProvider.NodeItem)) {
            return;
        }
        EditNodeDialog dialog = new EditNodeDialog(SwtUtil.getShell((Widget)this.membershipStatusField.getLabelControl(null)), this.getCloudManager(), ((NodeBrowserContentProvider.NodeItem)firstElement).getDescriptor());
        dialog.openNonBlocking(new DialogCallback(){

            public void dialogClosed(int returnCode) {
                if (returnCode == 0) {
                    ClusterAdminPage.this.refresh();
                }
            }
        });
    }

    private ICloudManager getCloudManager() {
        return CloudUiActivator.getInstance().getCloudManager();
    }

    void refresh() {
        ICloudManager cloudManager = this.getCloudManager();
        INodeEnvironment localInfo = cloudManager.getLocalInfo();
        INodeConfigurer nodeConfigurer = cloudManager.getNodeConfigurer(localInfo.getNodeId());
        this.nodeIdField.setText(localInfo.getNodeId());
        if (localInfo.inStandaloneMode()) {
            this.membershipStatusField.setText("The node operates standalone using an embedded ZooKeeper server. <a href=\"#connect\">Connect</a> it now.");
        } else {
            String serverInfo;
            try {
                serverInfo = ZooKeeperGate.get().getConnectedServerInfo();
            }
            catch (Exception exception) {
                serverInfo = null;
            }
            String connectString = StringUtils.trimToEmpty((String)nodeConfigurer.getConnectionString());
            if (serverInfo != null) {
                this.membershipStatusField.setText(String.format("The node is connected to %s (using connect string '%s'). <a href=\"#disconnect\">Disconnect it.</a>", serverInfo, StringEscapeUtils.escapeXml((String)connectString)));
            } else {
                this.membershipStatusField.setText(String.format("The node is currently not connected (using connect string '%s'). <a href=\"#disconnect\">Disconnect it.</a>", StringEscapeUtils.escapeXml((String)connectString)));
            }
        }
        this.treeViewer.refresh();
        this.updateButtons();
    }

    void retireSelectedNodes() {
        ICloudManager cloudManager = this.getCloudManager();
        MultiStatus result = new MultiStatus("org.eclipse.gyrex.admin.ui.cloud", 0, "Some nodes could not be retired.", null);
        for (Object object : (IStructuredSelection)this.treeViewer.getSelection()) {
            IStatus status;
            NodeBrowserContentProvider.NodeItem nodeItem;
            if (!(object instanceof NodeBrowserContentProvider.NodeItem) || !(nodeItem = (NodeBrowserContentProvider.NodeItem)object).isApproved() || (status = cloudManager.retireNode(nodeItem.getDescriptor().getId())).isOK()) continue;
            result.add(status);
        }
        if (!result.isOK()) {
            Policy.getStatusHandler().show((IStatus)result, "Error");
        }
    }

    void showConnectDialog() {
        ConnectToCloudDialog dialog = new ConnectToCloudDialog(this.getCloudManager(), SwtUtil.getShell((Widget)this.membershipStatusField.getLabelControl(null)));
        dialog.openNonBlocking(new DialogCallback(){

            public void dialogClosed(int returnCode) {
                if (returnCode == 0) {
                    ClusterAdminPage.this.refresh();
                }
            }
        });
    }

    void updateButtons() {
        int selectedElementsCount = ((IStructuredSelection)this.treeViewer.getSelection()).size();
        if (selectedElementsCount == 0) {
            this.approveButton.setEnabled(false);
            this.retireButton.setEnabled(false);
            this.editButton.setEnabled(false);
            return;
        }
        boolean hasApprovedNodes = false;
        boolean hasPendingNodes = false;
        for (Object object : (IStructuredSelection)this.treeViewer.getSelection()) {
            if (object instanceof NodeBrowserContentProvider.NodeItem) {
                NodeBrowserContentProvider.NodeItem nodeItem = (NodeBrowserContentProvider.NodeItem)object;
                hasApprovedNodes |= nodeItem.isApproved();
                hasPendingNodes |= !nodeItem.isApproved();
            }
            if (hasPendingNodes && hasApprovedNodes) break;
        }
        this.approveButton.setEnabled(hasPendingNodes);
        this.retireButton.setEnabled(hasApprovedNodes);
        this.editButton.setEnabled(selectedElementsCount == 1);
    }

    private final class NodeBrowserSortListener
    extends SelectionAdapter {
        private final NodeBrowserComparator comparator;
        private final TreeViewerColumn column;
        private final NodeBrowserComparator.SortIndex sortIndex;

        private NodeBrowserSortListener(NodeBrowserComparator comparator, NodeBrowserComparator.SortIndex sortIndex, TreeViewerColumn column) {
            this.comparator = comparator;
            this.sortIndex = sortIndex;
            this.column = column;
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.comparator.getIndex() == this.sortIndex) {
                this.comparator.setReverse(!this.comparator.isReverse());
            } else {
                this.comparator.setIndex(this.sortIndex);
                ClusterAdminPage.this.treeViewer.getTree().setSortColumn(this.column.getColumn());
            }
            ClusterAdminPage.this.treeViewer.getTree().setSortDirection(this.comparator.isReverse() ? 128 : 1024);
            ClusterAdminPage.this.treeViewer.refresh();
        }
    }
}

