/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ByteArrayCombinerStream;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.UnitOfWorkListener;
import org.apache.derby.client.net.NetConnection;

public abstract class Lob
implements UnitOfWorkListener {
    public static final int STRING = 2;
    public static final int ASCII_STREAM = 4;
    public static final int UNICODE_STREAM = 8;
    public static final int CHARACTER_STREAM = 16;
    public static final int BINARY_STREAM = 32;
    public static final int BINARY_STRING = 64;
    public static final int LOCATOR = 128;
    public static final int INVALID_LOCATOR = -1;
    protected Agent agent_;
    protected int dataType_ = 0;
    protected int locator_ = -1;
    private long sqlLength_;
    private boolean lengthObtained_;
    protected boolean isValid_ = true;
    private final boolean willBeLayerBStreamed_;
    private long updateCount;
    private int transactionID_;
    protected static final ClientMessageId LOB_OBJECT_LENGTH_UNKNOWN_YET = new ClientMessageId("XJ216.S");

    protected Lob(Agent agent, boolean willBeLayerBStreamed) {
        this.agent_ = agent;
        this.lengthObtained_ = false;
        this.willBeLayerBStreamed_ = willBeLayerBStreamed;
        this.transactionID_ = this.agent_.connection_.getTransactionID();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    long sqlLength() throws SqlException {
        if (this.lengthObtained_) {
            return this.sqlLength_;
        }
        if (this.isLocator()) {
            this.sqlLength_ = this.getLocatorLength();
            this.lengthObtained_ = true;
        } else {
            if (this.willBeLayerBStreamed()) {
                throw new SqlException(this.agent_.logWriter_, LOB_OBJECT_LENGTH_UNKNOWN_YET);
            }
            this.materializeStream();
        }
        return this.sqlLength_;
    }

    void setSqlLength(long length) {
        this.sqlLength_ = length;
        this.lengthObtained_ = true;
    }

    long getLocatorLength() throws SqlException {
        return -1L;
    }

    public void listenToUnitOfWork() {
        this.agent_.connection_.CommitAndRollbackListeners_.put(this, null);
    }

    public void completeLocalCommit(Iterator listenerIterator) {
        listenerIterator.remove();
    }

    public void completeLocalRollback(Iterator listenerIterator) {
        listenerIterator.remove();
    }

    public Agent getAgent() {
        return this.agent_;
    }

    void checkForClosedConnection() throws SqlException {
        if (this.agent_.connection_.isClosedX()) {
            this.agent_.checkForDeferredExceptions();
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("08003.C.2"));
        }
        this.agent_.checkForDeferredExceptions();
    }

    void completeLocalRollback() {
    }

    void completeLocalCommit() {
    }

    protected abstract void materializeStream() throws SqlException;

    protected InputStream materializeStream(InputStream is, String typeDesc) throws SqlException {
        int GROWBY = 32768;
        ArrayList<byte[]> byteArrays = new ArrayList<byte[]>();
        byte[] curBytes = new byte[32768];
        int totalLength = 0;
        int partLength = 0;
        try {
            do {
                if ((partLength = is.read(curBytes, 0, curBytes.length)) == curBytes.length) {
                    byteArrays.add(curBytes);
                    int newLength = totalLength + 32768;
                    curBytes = newLength < 0 || newLength == Integer.MAX_VALUE ? new byte[Integer.MAX_VALUE - totalLength] : new byte[32768];
                }
                if (partLength <= 0) continue;
                totalLength += partLength;
            } while (partLength == 32768);
            if (is.read() != -1) {
                throw new SqlException(null, new ClientMessageId("22003"), typeDesc);
            }
            if (partLength > 0) {
                byteArrays.add(curBytes);
            }
            curBytes = null;
            this.sqlLength_ = totalLength;
            this.lengthObtained_ = true;
            return new ByteArrayCombinerStream(byteArrays, totalLength);
        }
        catch (IOException ioe) {
            throw new SqlException(null, new ClientMessageId("XCL30.S"), (Object)typeDesc, (Throwable)ioe);
        }
    }

    public abstract long length() throws SQLException;

    protected static boolean isLayerBStreamingPossible(Agent agent) {
        NetConnection netConn = (NetConnection)agent.connection_;
        int securityMechanism = netConn.getSecurityMechanism();
        return netConn.serverSupportsLayerBStreaming() && securityMechanism != 12 && securityMechanism != 13;
    }

    public boolean willBeLayerBStreamed() {
        return this.willBeLayerBStreamed_;
    }

    public boolean isLocator() {
        return (this.dataType_ & 0x80) == 128;
    }

    public int getLocator() {
        return this.locator_;
    }

    protected void checkPosAndLength(long pos, long length) throws SQLException {
        if (pos <= 0L) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ070.S"), new Long(pos)).getSQLException();
        }
        if (length < 0L) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ071.S"), new Integer((int)length)).getSQLException();
        }
        if (length > this.length() - (pos - 1L)) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ087.S"), (Object)new Long(pos), new Long(length)).getSQLException();
        }
    }

    protected synchronized void incrementUpdateCount() {
        ++this.updateCount;
    }

    long getUpdateCount() {
        return this.updateCount;
    }

    void checkForLocatorValidity() throws SqlException {
        this.sqlLength();
    }

    protected void checkValidity() throws SQLException {
        try {
            this.agent_.connection_.checkForClosedConnection();
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
        if (!this.isValid_ || this.transactionID_ != this.agent_.connection_.getTransactionID()) {
            throw new SqlException(null, new ClientMessageId("XJ215.S")).getSQLException();
        }
    }
}

