/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import javax.transaction.xa.Xid;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Utils;
import org.apache.derby.client.net.CcsidManager;
import org.apache.derby.client.net.ConnectionRequestInterface;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetConfiguration;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.Request;
import org.apache.derby.client.net.Typdef;

public class NetConnectionRequest
extends Request
implements ConnectionRequestInterface {
    NetConnectionRequest(NetAgent netAgent, CcsidManager ccsidManager, int bufferSize) {
        super(netAgent, ccsidManager, bufferSize);
    }

    void writeExchangeServerAttributes(String externalName, int targetAgent, int targetSqlam, int targetRdb, int targetSecmgr, int targetCmntcpip, int targetCmnappc, int targetXamgr, int targetSyncptmgr, int targetRsyncmgr) throws SqlException {
        this.buildEXCSAT(externalName, targetAgent, targetSqlam, targetRdb, targetSecmgr, targetCmntcpip, targetCmnappc, targetXamgr, targetSyncptmgr, targetRsyncmgr);
    }

    void writeDummyExchangeServerAttributes() throws SqlException {
        this.buildDummyEXCSAT();
    }

    void writeAccessSecurity(int securityMechanism, String databaseName, byte[] publicKey) throws SqlException {
        this.buildACCSEC(securityMechanism, databaseName, publicKey);
    }

    void writeSecurityCheck(int securityMechanism, String databaseName, String userid, String password, byte[] encryptedUserid, byte[] encryptedPassword) throws SqlException {
        this.buildSECCHK(securityMechanism, databaseName, userid, password, encryptedUserid, encryptedPassword);
    }

    void writeAccessDatabase(String rdbnam, boolean readOnly, byte[] correlationToken, byte[] productData, Typdef typdef) throws SqlException {
        this.buildACCRDB(rdbnam, readOnly, correlationToken, productData, typdef);
    }

    public void writeCommitSubstitute(NetConnection connection) throws SqlException {
        this.buildDummyEXCSAT();
    }

    public void writeLocalCommit(NetConnection connection) throws SqlException {
        this.buildRDBCMM();
    }

    public void writeLocalRollback(NetConnection connection) throws SqlException {
        this.buildRDBRLLBCK();
    }

    public void writeLocalXAStart(NetConnection connection) throws SqlException {
    }

    public void writeLocalXACommit(NetConnection conn) throws SqlException {
    }

    public void writeLocalXARollback(NetConnection conn) throws SqlException {
    }

    public void writeXaStartUnitOfWork(NetConnection conn) throws SqlException {
    }

    public void writeXaEndUnitOfWork(NetConnection conn) throws SqlException {
    }

    protected void writeXaPrepare(NetConnection conn) throws SqlException {
    }

    protected void writeXaCommit(NetConnection conn, Xid xid) throws SqlException {
    }

    protected void writeXaRollback(NetConnection conn, Xid xid) throws SqlException {
    }

    protected void writeXaRecover(NetConnection conn, int flag) throws SqlException {
    }

    protected void writeXaForget(NetConnection conn, Xid xid) throws SqlException {
    }

    public void writeSYNCType(int codepoint, int syncType) {
        this.writeScalar1Byte(codepoint, syncType);
    }

    public void writeForget(int codepoint, int value) {
    }

    public void writeReleaseConversation(int codepoint, int value) {
    }

    void writeNullXID(int codepoint) {
    }

    void writeXID(int codepoint, Xid xid) throws SqlException {
    }

    void writeXAFlags(int codepoint, int xaFlags) {
    }

    void writeXATimeout(int codepoint, long xaTimeout) {
    }

    void buildRDBCMM() throws SqlException {
        this.createCommand();
        this.writeLengthCodePoint(4, 8206);
    }

    void buildRDBRLLBCK() throws SqlException {
        this.createCommand();
        this.writeLengthCodePoint(4, 8207);
    }

    void buildEXCSAT(String externalName, int targetAgent, int targetSqlam, int targetRdb, int targetSecmgr, int targetCmntcpip, int targetCmnappc, int targetXamgr, int targetSyncptmgr, int targetRsyncmgr) throws SqlException {
        this.createCommand();
        this.markLengthBytes(4161);
        this.buildEXTNAM(externalName);
        this.buildSRVNAM("Derby");
        this.buildSRVRLSLV();
        this.buildMGRLVLLS(targetAgent, targetSqlam, targetRdb, targetSecmgr, targetXamgr, targetSyncptmgr, targetRsyncmgr);
        this.buildSRVCLSNM();
        this.updateLengthBytes();
    }

    void buildDummyEXCSAT() throws SqlException {
        this.createCommand();
        this.markLengthBytes(4161);
        this.updateLengthBytes();
    }

    void buildACCSEC(int secmec, String rdbnam, byte[] sectkn) throws SqlException {
        this.createCommand();
        this.markLengthBytes(4205);
        this.buildSECMEC(secmec);
        this.buildRDBNAM(rdbnam, true);
        if (sectkn != null) {
            this.buildSECTKN(sectkn);
        }
        this.updateLengthBytes();
    }

    void buildSECCHK(int secmec, String rdbnam, String user, String password, byte[] sectkn, byte[] sectkn2) throws SqlException {
        this.createCommand();
        this.markLengthBytes(4206);
        this.buildSECMEC(secmec);
        this.buildRDBNAM(rdbnam, false);
        if (user != null) {
            this.buildUSRID(user);
        }
        if (password != null) {
            this.buildPASSWORD(password);
        }
        if (sectkn != null) {
            this.buildSECTKN(sectkn);
        }
        if (sectkn2 != null) {
            this.buildSECTKN(sectkn2);
        }
        this.updateLengthBytes();
    }

    void buildACCRDB(String rdbnam, boolean readOnly, byte[] crrtkn, byte[] prddta, Typdef typdef) throws SqlException {
        this.createCommand();
        this.markLengthBytes(8193);
        this.buildRDBNAM(rdbnam, false);
        this.buildRDBACCCL();
        this.buildPRDID();
        this.buildPRDDTA(prddta);
        this.buildTYPDEFNAM(typdef.getTypdefnam());
        if (crrtkn == null) {
            this.netAgent_.netConnection_.constructCrrtkn();
        }
        this.buildCRRTKN(this.netAgent_.netConnection_.crrtkn_);
        this.buildTYPDEFOVR(typdef.isCcsidSbcSet(), typdef.getCcsidSbc(), typdef.isCcsidDbcSet(), typdef.getCcsidDbc(), typdef.isCcsidMbcSet(), typdef.getCcsidMbc());
        this.buildRDBALWUPD(readOnly);
        this.updateLengthBytes();
    }

    void buildSYNCCTLMigrate() throws SqlException {
    }

    void buildSYNCCTLCommit(int xaFlags, Xid xid) throws SqlException {
    }

    void buildSYNCCTLRollback(int xaFlags) throws SqlException {
    }

    private void buildEXTNAM(String extnam) throws SqlException {
        int extnamTruncateLength = Utils.min(extnam.length(), 255);
        this.writeScalarString(4446, extnam.substring(0, extnamTruncateLength));
    }

    private void buildSRVNAM(String srvnam) throws SqlException {
        int srvnamTruncateLength = Utils.min(srvnam.length(), 255);
        this.writeScalarString(4461, srvnam.substring(0, srvnamTruncateLength));
    }

    private void buildSRVRLSLV() throws SqlException {
        this.writeScalarString(4442, NetConfiguration.SRVRLSLV);
    }

    private void buildSRVCLSNM() throws SqlException {
        this.writeScalarString(4423, "QDERBY/JVM");
    }

    private void buildSECMEC(int secmec) throws SqlException {
        this.writeScalar2Bytes(4514, secmec);
    }

    private void buildRDBNAM(String rdbnam, boolean dontSendOnConversionError) throws SqlException {
        if (dontSendOnConversionError) {
            try {
                this.ccsidManager_.convertFromUCS2(rdbnam, this.netAgent_);
            }
            catch (SqlException se) {
                this.netAgent_.exceptionConvertingRdbnam = se;
                return;
            }
        }
        this.writeScalarString(8464, rdbnam, 18, 255, "08001.C.9");
    }

    private void buildSECTKN(byte[] sectkn) throws SqlException {
        if (sectkn.length > 32763) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("08001.C.10"));
        }
        this.writeScalarBytes(4572, sectkn);
    }

    private void buildUSRID(String usrid) throws SqlException {
        this.writeScalarString(4512, usrid, 0, 255, "08001.C.11");
    }

    private void buildPASSWORD(String password) throws SqlException {
        int passwordLength = password.length();
        if (passwordLength == 0) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("08001.C.12"));
        }
        if (this.netAgent_.logWriter_ != null) {
            this.passwordIncluded_ = true;
            this.passwordStart_ = this.offset_ + 4;
        }
        this.writeScalarString(4513, password, 0, 255, "08001.C.12");
        if (this.netAgent_.logWriter_ != null) {
            this.passwordLength_ = this.offset_ - this.passwordStart_;
        }
    }

    private void buildRDBACCCL() throws SqlException {
        this.writeScalar2Bytes(8463, 9223);
    }

    private void buildPRDID() throws SqlException {
        this.writeScalarString(4398, NetConfiguration.PRDID);
    }

    private void buildPRDDTA(byte[] prddta) throws SqlException {
        int prddtaLength = (prddta[0] & 0xFF) + 1;
        this.writeScalarBytes(8452, prddta, 0, prddtaLength);
    }

    private void buildTYPDEFNAM(String typdefnam) throws SqlException {
        this.writeScalarString(47, typdefnam);
    }

    void buildTYPDEFOVR(boolean sendCcsidSbc, int ccsidSbc, boolean sendCcsidDbc, int ccsidDbc, boolean sendCcsidMbc, int ccsidMbc) throws SqlException {
        this.markLengthBytes(53);
        if (sendCcsidSbc) {
            this.writeScalar2Bytes(4508, ccsidSbc);
        }
        if (sendCcsidDbc) {
            this.writeScalar2Bytes(4509, ccsidDbc);
        }
        if (sendCcsidMbc) {
            this.writeScalar2Bytes(4510, ccsidMbc);
        }
        this.updateLengthBytes();
    }

    private void buildMGRLVLLS(int agent, int sqlam, int rdb, int secmgr, int xamgr, int syncptmgr, int rsyncmgr) throws SqlException {
        this.markLengthBytes(5124);
        this.writeCodePoint4Bytes(5123, agent);
        this.writeCodePoint4Bytes(9223, sqlam);
        this.writeCodePoint4Bytes(9231, rdb);
        this.writeCodePoint4Bytes(5184, secmgr);
        if (this.netAgent_.netConnection_.isXAConnection()) {
            if (xamgr != 0) {
                this.writeCodePoint4Bytes(7169, xamgr);
            }
            if (syncptmgr != 0) {
                this.writeCodePoint4Bytes(5312, syncptmgr);
            }
            if (rsyncmgr != 0) {
                this.writeCodePoint4Bytes(5313, rsyncmgr);
            }
        }
        this.updateLengthBytes();
    }

    private void buildCRRTKN(byte[] crrtkn) throws SqlException {
        this.writeScalarBytes(8501, crrtkn);
    }

    private void buildRDBALWUPD(boolean readOnly) throws SqlException {
        if (readOnly) {
            this.writeScalar1Byte(8474, -16);
        }
    }
}

