/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.storage.lookup;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.persistence.internal.PersistenceActivator;
import org.eclipse.gyrex.persistence.storage.Repository;
import org.eclipse.gyrex.persistence.storage.content.RepositoryContentType;
import org.eclipse.gyrex.persistence.storage.content.RepositoryContentTypeSupport;
import org.eclipse.gyrex.persistence.storage.exceptions.ResourceFailureException;
import org.eclipse.gyrex.persistence.storage.lookup.IRepositoryLookupStrategy;
import org.eclipse.gyrex.persistence.storage.lookup.RepositoryContentTypeAssignments;
import org.eclipse.gyrex.preferences.CloudScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public final class DefaultRepositoryLookupStrategy
implements IRepositoryLookupStrategy {
    private static DefaultRepositoryLookupStrategy sharedInstance;

    public static DefaultRepositoryLookupStrategy getDefault() {
        if (sharedInstance == null) {
            sharedInstance = new DefaultRepositoryLookupStrategy();
            return sharedInstance;
        }
        return sharedInstance;
    }

    private DefaultRepositoryLookupStrategy() {
    }

    private Preferences getAssignmentsNode() {
        return CloudScope.INSTANCE.getNode("org.eclipse.gyrex.persistence").node("assignments");
    }

    public RepositoryContentTypeAssignments getContentTypeAssignments(String repositoryId) {
        if (!IdHelper.isValidId((String)repositoryId)) {
            throw new IllegalArgumentException("repositoryId is invalid");
        }
        RepositoryContentTypeAssignments assignments = new RepositoryContentTypeAssignments(repositoryId);
        try {
            Preferences assignmentsNode = this.getAssignmentsNode();
            String[] stringArray = assignmentsNode.childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String mediaTypeType = stringArray[n2];
                Preferences mediaTypeNode = assignmentsNode.node(mediaTypeType);
                String[] stringArray2 = mediaTypeNode.childrenNames();
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String mediaTypeSubtype = stringArray2[n4];
                    Preferences contentTypeNode = mediaTypeNode.node(mediaTypeSubtype);
                    String[] stringArray3 = contentTypeNode.keys();
                    int n5 = stringArray3.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String contextPath = stringArray3[n6];
                        String assignedRepoId = contentTypeNode.get(contextPath, null);
                        if (StringUtils.equals((String)repositoryId, (String)assignedRepoId)) {
                            assignments.add(contextPath, mediaTypeType, mediaTypeSubtype);
                        }
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            throw new ResourceFailureException(String.format("Error reading repository content type assignments for repository '%s'. %s", repositoryId, e.getMessage()), e);
        }
        return assignments;
    }

    @Override
    public Repository getRepository(IRuntimeContext context, RepositoryContentType contentType) throws IllegalStateException {
        String repositoryId;
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("contentType must not be null");
        }
        try {
            repositoryId = this.getRepositoryId(context, contentType);
        }
        catch (BackingStoreException e) {
            throw new ResourceFailureException(String.format("Error reading repository content type assignments for content type '%s' in context '%s'. %s", contentType.getMediaType(), context.getContextPath(), e.getMessage()), e);
        }
        if (repositoryId == null) {
            throw new IllegalStateException(String.format("No repository available for storing content of type '%s' in context '%s'.", contentType.getMediaType(), context.getContextPath()));
        }
        Repository repository = this.getRepository(repositoryId);
        if (repository == null) {
            throw new IllegalStateException(String.format("Failed creating repository '%s' in context '%s' for content of type '%s'.", repositoryId, contentType.getMediaType(), context.getContextPath()));
        }
        RepositoryContentTypeSupport contentTypeSupport = repository.getContentTypeSupport();
        if (contentTypeSupport == null || !contentTypeSupport.isSupported(contentType)) {
            throw new IllegalStateException(String.format("The repository '%s' in context '%s' of type '%s' does not support content of type '%s'.", new Object[]{repositoryId, context.getContextPath(), repository.getRepositoryProvider().getRepositoryTypeName(), contentType}));
        }
        return repository;
    }

    private Repository getRepository(String repositoryId) {
        return PersistenceActivator.getInstance().getRepositoriesManager().getRepository(repositoryId);
    }

    private String getRepositoryId(IRuntimeContext context, RepositoryContentType contentType) throws BackingStoreException {
        Preferences assignmentsNode = this.getAssignmentsNode();
        if (!assignmentsNode.nodeExists(contentType.getMediaType())) {
            return null;
        }
        Preferences contentTypeAssignments = assignmentsNode.node(contentType.getMediaTypeType()).node(contentType.getMediaTypeSubType());
        IPath path = context.getContextPath();
        String repositoryId = contentTypeAssignments.get(path.toString(), null);
        while (repositoryId == null && path.segmentCount() > 0) {
            path = path.removeLastSegments(1);
            repositoryId = contentTypeAssignments.get(path.toString(), null);
        }
        return repositoryId;
    }

    public void setRepository(IRuntimeContext context, RepositoryContentType contentType, String repositoryId) throws BackingStoreException {
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("contentType must not be null");
        }
        if (repositoryId != null && !IdHelper.isValidId((String)repositoryId)) {
            throw new IllegalArgumentException("repositoryId is invalid");
        }
        Preferences assignmentsNode = this.getAssignmentsNode();
        String contextPreferenceKey = context.getContextPath().toString();
        Preferences contentTypeAssignments = assignmentsNode.node(contentType.getMediaTypeType()).node(contentType.getMediaTypeSubType());
        contentTypeAssignments.sync();
        if (repositoryId != null) {
            contentTypeAssignments.put(contextPreferenceKey, repositoryId);
        } else {
            contentTypeAssignments.remove(contextPreferenceKey);
            if (contentTypeAssignments.keys().length == 0) {
                Preferences contentTypeAssignmentsParent = contentTypeAssignments.parent();
                contentTypeAssignments.removeNode();
                if (contentTypeAssignmentsParent.childrenNames().length == 0) {
                    contentTypeAssignmentsParent.removeNode();
                }
            }
        }
        assignmentsNode.flush();
    }
}

