/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.search.solr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.model.common.ModelException;
import org.eclipse.gyrex.model.common.provider.BaseModelManager;
import org.eclipse.gyrex.monitoring.metrics.MetricSet;
import org.eclipse.gyrex.monitoring.metrics.ThroughputMetric;
import org.eclipse.gyrex.persistence.solr.SolrServerRepository;
import org.eclipse.gyrex.persistence.storage.Repository;
import org.eclipse.gyrex.persistence.storage.RepositoryMetadata;
import org.eclipse.gyrex.persistence.storage.exceptions.ResourceFailureException;
import org.eclipse.gyrex.search.ISearchManager;
import org.eclipse.gyrex.search.documents.IDocument;
import org.eclipse.gyrex.search.documents.IDocumentAttribute;
import org.eclipse.gyrex.search.facets.IFacet;
import org.eclipse.gyrex.search.internal.SearchDebug;
import org.eclipse.gyrex.search.internal.solr.SolrSearchManagerMetrics;
import org.eclipse.gyrex.search.internal.solr.documents.StoredDocument;
import org.eclipse.gyrex.search.internal.solr.documents.TransientDocument;
import org.eclipse.gyrex.search.internal.solr.facets.Facet;
import org.eclipse.gyrex.search.internal.solr.query.AttributeFilter;
import org.eclipse.gyrex.search.internal.solr.query.FacetFilter;
import org.eclipse.gyrex.search.internal.solr.query.QueryImpl;
import org.eclipse.gyrex.search.internal.solr.result.ResultImpl;
import org.eclipse.gyrex.search.query.FacetSelectionStrategy;
import org.eclipse.gyrex.search.query.IAttributeFilter;
import org.eclipse.gyrex.search.query.IFacetFilter;
import org.eclipse.gyrex.search.query.IQuery;
import org.eclipse.gyrex.search.query.SortDirection;
import org.eclipse.gyrex.search.result.IResult;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;

public abstract class BaseSolrSearchManager
extends BaseModelManager<SolrServerRepository>
implements ISearchManager {
    private final AtomicBoolean commitsAllowed = new AtomicBoolean(true);

    protected BaseSolrSearchManager(IRuntimeContext context, SolrServerRepository repository, String metricsId) {
        super(context, (Repository)repository, (MetricSet)new SolrSearchManagerMetrics(metricsId, context, repository));
    }

    private void checkFacet(IFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException("facet must not be null");
        }
        if (!(facet instanceof Facet)) {
            throw new IllegalArgumentException(NLS.bind((String)"facet type {0} not supported by this manager", facet.getClass()));
        }
    }

    public final void commit(boolean waitFlush, boolean waitSearcher) {
        try {
            ((SolrServerRepository)this.getRepository()).getSolrServer().commit(waitFlush, waitSearcher);
        }
        catch (Exception e) {
            throw new ResourceFailureException(NLS.bind((String)"Error committing in repository {0}. {1}", (Object[])new Object[]{this.getRepositoryId(), e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public final IDocument createDocument() {
        return new TransientDocument();
    }

    @Override
    public final IFacet createFacet(String attributeId) throws IllegalArgumentException {
        ThroughputMetric writeFacetMetric = this.getSolrSearchManagerMetrics().getWriteFacetMetric();
        long start = writeFacetMetric.requestStarted();
        Facet facet = new Facet(attributeId, this);
        writeFacetMetric.requestFinished(1L, System.currentTimeMillis() - start);
        return facet;
    }

    @Override
    public final IQuery createQuery() {
        return new QueryImpl();
    }

    private SolrInputDocument createSolrDoc(IDocument document) {
        SolrInputDocument solrDoc = new SolrInputDocument();
        Collection<IDocumentAttribute<?>> attributes = document.getAttributes().values();
        for (IDocumentAttribute<?> attr : attributes) {
            Collection<?> values = attr.getValues();
            for (Object value : values) {
                solrDoc.addField(attr.getId(), value);
            }
        }
        return solrDoc;
    }

    protected SolrQuery createSolrQuery(IQuery query) {
        if (!(query instanceof QueryImpl)) {
            throw new IllegalArgumentException("invalid query object; not created by this manager");
        }
        QueryImpl queryImpl = (QueryImpl)query;
        SolrQuery solrQuery = new SolrQuery();
        if (query.getAdvancedQuery() != null) {
            solrQuery.setQuery(query.getAdvancedQuery());
        } else if (query.getQuery() != null) {
            solrQuery.setQuery(query.getQuery());
        } else {
            solrQuery.setQuery("*:*");
        }
        solrQuery.setStart(new Integer((int)query.getStartIndex()));
        solrQuery.setRows(new Integer(query.getMaxResults()));
        for (String filterQuery : query.getFilterQueries()) {
            solrQuery.addFilterQuery(new String[]{filterQuery});
        }
        for (IAttributeFilter attributeFilter : query.getAttributeFilters()) {
            solrQuery.addFilterQuery(new String[]{((AttributeFilter)attributeFilter).toFilterQuery()});
        }
        Map<String, SortDirection> sortFields = query.getSortFields();
        for (Map.Entry<String, SortDirection> sortEntry : sortFields.entrySet()) {
            switch (sortEntry.getValue()) {
                case DESCENDING: {
                    solrQuery.addSortField(sortEntry.getKey(), SolrQuery.ORDER.desc);
                    break;
                }
                default: {
                    solrQuery.addSortField(sortEntry.getKey(), SolrQuery.ORDER.asc);
                }
            }
        }
        Map<String, IFacet> facets = this.getFacets();
        if (facets != null) {
            queryImpl.setFacetsInUse(facets);
            for (IFacet iFacet : facets.values()) {
                String facetField = iFacet.getAttributeId();
                FacetSelectionStrategy selectionStrategy = iFacet.getSelectionStrategy();
                if (selectionStrategy != null && selectionStrategy == FacetSelectionStrategy.MULTI) {
                    solrQuery.addFacetField(new String[]{"{!ex=" + iFacet.getAttributeId() + "}" + facetField});
                    continue;
                }
                solrQuery.addFacetField(new String[]{facetField});
            }
            for (IFacetFilter iFacetFilter : query.getFacetFilters()) {
                solrQuery.addFilterQuery(new String[]{((FacetFilter)iFacetFilter).toFilterQuery()});
            }
        } else {
            solrQuery.setFacet(false);
        }
        switch (query.getResultProjection()) {
            case FULL: {
                solrQuery.setFields(new String[]{"*"});
                break;
            }
            default: {
                solrQuery.setFields(null);
            }
        }
        if (SearchDebug.debug) {
            solrQuery.setShowDebugInfo(true);
        }
        for (Map.Entry entry : query.getQueryOptions().entrySet()) {
            solrQuery.setParam((String)entry.getKey(), new String[]{(String)entry.getValue()});
        }
        return solrQuery;
    }

    @Override
    public final void deleteFacet(IFacet facet) throws IllegalArgumentException, ModelException {
        this.checkFacet(facet);
        try {
            RepositoryMetadata facetsMetadata = this.getFacetsMetadata();
            facetsMetadata.sync();
            facetsMetadata.remove(facet.getAttributeId());
            facetsMetadata.flush();
        }
        catch (BackingStoreException e) {
            throw new ModelException((IStatus)new Status(4, "org.eclipse.gyrex.search", "Unable to remove facet. " + e.getMessage(), (Throwable)e));
        }
    }

    protected void doClose() {
        this.getSolrSearchManagerMetrics().getStatusMetric().setStatus("closed", "manager closed");
    }

    @Override
    public IResult findByQuery(IQuery query) {
        if (query == null || !(query instanceof QueryImpl)) {
            throw new IllegalArgumentException("Invalid query. Must be created using #createQuery from this service instance.");
        }
        ThroughputMetric queryMetric = this.getSolrSearchManagerMetrics().getQueryMetric();
        long requestStarted = queryMetric.requestStarted();
        SolrQuery solrQuery = this.createSolrQuery(query);
        QueryResponse response = this.query(solrQuery);
        queryMetric.requestFinished(1L, System.currentTimeMillis() - requestStarted);
        return new ResultImpl(this.getContext(), (QueryImpl)query, response);
    }

    @Override
    public final IDocument findDocumentById(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        ThroughputMetric retrievedByIdMetric = this.getSolrSearchManagerMetrics().getDocsRetrievedByIdMetric();
        long requestStarted = retrievedByIdMetric.requestStarted();
        try {
            SolrQuery query = new SolrQuery();
            query.setQuery("id:" + ClientUtils.escapeQueryChars((String)id));
            query.setStart(Integer.valueOf(0)).setRows(Integer.valueOf(1));
            query.setFields(new String[]{"*"});
            QueryResponse response = this.query(query);
            SolrDocumentList results = response.getResults();
            if (!results.isEmpty()) {
                retrievedByIdMetric.requestFinished(1L, System.currentTimeMillis() - requestStarted);
                return new StoredDocument((SolrDocument)results.iterator().next());
            }
            retrievedByIdMetric.requestFinished(1L, System.currentTimeMillis() - requestStarted);
            return null;
        }
        catch (RuntimeException e) {
            retrievedByIdMetric.requestFailed();
            throw e;
        }
        catch (Error e) {
            retrievedByIdMetric.requestFailed();
            throw e;
        }
    }

    @Override
    public final Map<String, IDocument> findDocumentsById(Collection<String> ids) {
        if (ids == null) {
            throw new IllegalArgumentException("ids must not be null");
        }
        ThroughputMetric retrievedByIdMetric = this.getSolrSearchManagerMetrics().getDocsRetrievedByIdMetric();
        long requestStarted = retrievedByIdMetric.requestStarted();
        try {
            SolrQuery query = new SolrQuery();
            StringBuilder queryStr = new StringBuilder();
            int length = 0;
            queryStr.append("id").append(":(");
            for (String id : ids) {
                if (StringUtils.isBlank((String)id)) {
                    throw new IllegalArgumentException("unsupport blank id found in ids list");
                }
                if (length > 0) {
                    queryStr.append(" OR ");
                }
                queryStr.append(ClientUtils.escapeQueryChars((String)id));
                ++length;
            }
            if (length == 0) {
                throw new IllegalArgumentException("ids list is empty");
            }
            query.setQuery(queryStr.append(')').toString());
            query.setStart(Integer.valueOf(0)).setRows(Integer.valueOf(length));
            query.setFields(new String[]{"*"});
            QueryResponse response = this.query(query);
            SolrDocumentList results = response.getResults();
            if (!results.isEmpty()) {
                HashMap<String, StoredDocument> map = new HashMap<String, StoredDocument>(results.size());
                Iterator stream = results.iterator();
                while (stream.hasNext()) {
                    StoredDocument doc = new StoredDocument((SolrDocument)stream.next());
                    map.put(doc.getId(), doc);
                }
                retrievedByIdMetric.requestFinished((long)length, System.currentTimeMillis() - requestStarted);
                return Collections.unmodifiableMap(map);
            }
            retrievedByIdMetric.requestFinished((long)length, System.currentTimeMillis() - requestStarted);
            return Collections.emptyMap();
        }
        catch (RuntimeException e) {
            retrievedByIdMetric.requestFailed();
            throw e;
        }
        catch (Error e) {
            retrievedByIdMetric.requestFailed();
            throw e;
        }
    }

    @Override
    public final Map<String, IFacet> getFacets() throws ModelException {
        ThroughputMetric readFacetMetric = this.getSolrSearchManagerMetrics().getReadFacetMetric();
        try {
            long start = readFacetMetric.requestStarted();
            RepositoryMetadata facetsMetadata = this.getFacetsMetadata();
            Collection keys = facetsMetadata.getKeys();
            HashMap<String, Facet> map = new HashMap<String, Facet>(keys.size());
            for (String key : keys) {
                byte[] bytes = facetsMetadata.get(key);
                if (bytes == null) continue;
                map.put(key, new Facet(key, this, bytes));
            }
            readFacetMetric.requestFinished((long)map.size(), System.currentTimeMillis() - start);
            return Collections.unmodifiableMap(map);
        }
        catch (BackingStoreException e) {
            readFacetMetric.requestFailed();
            throw new ModelException((IStatus)new Status(4, "org.eclipse.gyrex.search", "Unable to load facets. " + e.getMessage(), (Throwable)e));
        }
    }

    private RepositoryMetadata getFacetsMetadata() {
        return ((SolrServerRepository)this.getRepository()).getMetadata("facets");
    }

    protected final String getRepositoryId() {
        return ((SolrServerRepository)this.getRepository()).getRepositoryId();
    }

    private final SolrSearchManagerMetrics getSolrSearchManagerMetrics() {
        return (SolrSearchManagerMetrics)this.getMetrics();
    }

    public final void optimize(boolean waitFlush, boolean waitSearcher) {
        try {
            ((SolrServerRepository)this.getRepository()).getSolrServer().optimize(waitFlush, waitSearcher);
        }
        catch (Exception e) {
            throw new ResourceFailureException(NLS.bind((String)"Error optimizing repository {0}. {1}", (Object[])new Object[]{this.getRepositoryId(), e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public final void publishDocuments(Collection<IDocument> documents) {
        ThroughputMetric publishedMetric = this.getSolrSearchManagerMetrics().getDocsPublishedMetric();
        long requestStarted = publishedMetric.requestStarted();
        ArrayList<SolrInputDocument> docs = new ArrayList<SolrInputDocument>();
        for (IDocument document : documents) {
            if (document.getId() == null) {
                document.setId(UUID.randomUUID().toString());
            }
            docs.add(this.createSolrDoc(document));
        }
        try {
            SolrServer solrServer = ((SolrServerRepository)this.getRepository()).getSolrServer();
            if (this.commitsAllowed.get()) {
                solrServer.add(docs);
                solrServer.commit();
            } else {
                solrServer.add(docs);
            }
            publishedMetric.requestFinished((long)docs.size(), System.currentTimeMillis() - requestStarted);
        }
        catch (Exception e) {
            publishedMetric.requestFailed();
            throw new ResourceFailureException(String.format("Error publishing documents. %s", ExceptionUtils.getRootCauseMessage((Throwable)e)), (Throwable)e);
        }
    }

    public final QueryResponse query(SolrQuery solrQuery) {
        ThroughputMetric queryMetric = this.getSolrSearchManagerMetrics().getQueryMetric();
        String query = solrQuery.toString();
        try {
            long started = queryMetric.requestStarted();
            QueryResponse response = query.length() > 2000 ? ((SolrServerRepository)this.getRepository()).getSolrServerOptimizedForQuery().query((SolrParams)solrQuery, SolrRequest.METHOD.POST) : ((SolrServerRepository)this.getRepository()).getSolrServerOptimizedForQuery().query((SolrParams)solrQuery, SolrRequest.METHOD.GET);
            queryMetric.requestFinished(1L, System.currentTimeMillis() - started);
            return response;
        }
        catch (Exception e) {
            queryMetric.requestFailed();
            throw new ResourceFailureException(NLS.bind((String)"Error querying documents in repository {0}. {1}", (Object[])new Object[]{this.getRepositoryId(), e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public final void removeDocuments(Collection<String> documentIds) {
        try {
            ((SolrServerRepository)this.getRepository()).getSolrServer().deleteById((List)(documentIds instanceof List ? (List<Object>)documentIds : new ArrayList<String>(documentIds)));
        }
        catch (Exception e) {
            throw new ResourceFailureException(NLS.bind((String)"Error removing documents in repository {0}. {1}", (Object[])new Object[]{this.getRepositoryId(), e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public final void saveFacet(IFacet facet) throws IllegalArgumentException, ModelException {
        ThroughputMetric writeFacetMetric = this.getSolrSearchManagerMetrics().getWriteFacetMetric();
        long start = writeFacetMetric.requestStarted();
        this.checkFacet(facet);
        try {
            RepositoryMetadata facetsMetadata = this.getFacetsMetadata();
            facetsMetadata.sync();
            facetsMetadata.put(facet.getAttributeId(), ((Facet)facet).toByteArray());
            facetsMetadata.flush();
            writeFacetMetric.requestFinished(1L, System.currentTimeMillis() - start);
        }
        catch (BackingStoreException e) {
            writeFacetMetric.requestFailed();
            throw new ModelException((IStatus)new Status(4, "org.eclipse.gyrex.search", "Unable to save facet. " + e.getMessage(), (Throwable)e));
        }
    }

    public final boolean setCommitsEnabled(boolean enabled) {
        return this.commitsAllowed.getAndSet(enabled);
    }
}

