/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.jpa.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.gemini.jpa.GeminiUtil;
import org.eclipse.gemini.jpa.classloader.CompositeEnumeration;

public class CompositeClassLoader
extends ClassLoader {
    private List<ClassLoader> classLoaders = new ArrayList<ClassLoader>();

    public CompositeClassLoader(ClassLoader loader1, ClassLoader loader2) {
        this.classLoaders.add(loader1);
        this.classLoaders.add(loader2);
    }

    public CompositeClassLoader(List<ClassLoader> loaders) {
        this.classLoaders.addAll(loaders);
    }

    public List<ClassLoader> getClassLoaders() {
        return this.classLoaders;
    }

    @Override
    public synchronized void clearAssertionStatus() {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            classLoader.clearAssertionStatus();
        }
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            GeminiUtil.debugClassLoader("Attempting getResource(", name, ") on ", classLoader.toString());
            URL resource = classLoader.getResource(name);
            if (resource == null) continue;
            GeminiUtil.debugClassLoader("Found resource(", name, ") from ", classLoader.toString());
            return resource;
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            GeminiUtil.debugClassLoader("Attempting getResourceAsStream(", name, ") on ", classLoader.toString());
            InputStream stream = classLoader.getResourceAsStream(name);
            if (stream == null) continue;
            GeminiUtil.debugClassLoader("Found resource(", name, ") from ", classLoader.toString());
            return stream;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList enumerations = new ArrayList(this.getClassLoaders().size());
        for (ClassLoader classLoader : this.getClassLoaders()) {
            GeminiUtil.debugClassLoader("Attempting getResources(", name, ") on ", classLoader.toString());
            Enumeration<URL> resources = classLoader.getResources(name);
            if (resources == null) continue;
            GeminiUtil.debugClassLoader("Found resources(", name, ") from ", classLoader.toString());
            enumerations.add(resources);
        }
        return new CompositeEnumeration<URL>(enumerations);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            GeminiUtil.debugClassLoader("Attempting loadClass(", name, ") on ", classLoader.toString());
            try {
                Class<?> aClass = classLoader.loadClass(name);
                return aClass;
            }
            catch (ClassNotFoundException classNotFoundException) {
                GeminiUtil.debugClassLoader("ClassNotFound '", name, "' by ", classLoader.toString());
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public synchronized void setClassAssertionStatus(String className, boolean enabled) {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            classLoader.setClassAssertionStatus(className, enabled);
        }
    }

    @Override
    public synchronized void setDefaultAssertionStatus(boolean enabled) {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            classLoader.setDefaultAssertionStatus(enabled);
        }
    }

    @Override
    public synchronized void setPackageAssertionStatus(String packageName, boolean enabled) {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            classLoader.setPackageAssertionStatus(packageName, enabled);
        }
    }
}

