/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.jpa.classloader;

import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.gemini.jpa.GeminiUtil;
import org.eclipse.gemini.jpa.xml.EclipseDotClasspathHandler;
import org.osgi.framework.Bundle;
import org.xml.sax.helpers.DefaultHandler;

public class EclipseDotClasspathHelper {
    private EclipseDotClasspathHandler handler;

    public String getBinPath(Bundle bundle) {
        if (this.handler != null) {
            return this.handler.getBinPath();
        }
        this.handler = new EclipseDotClasspathHandler();
        URL resource = bundle.getEntry(".classpath");
        if (resource == null) {
            return null;
        }
        InputStream in = null;
        try {
            in = resource.openStream();
            GeminiUtil.debug("Parsing Eclipse .classpath");
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(in, (DefaultHandler)this.handler);
            String binPath = this.handler.getBinPath();
            GeminiUtil.debug("Finished parsing Eclipse .classpath: ", (Object)binPath);
            String string = binPath;
            return string;
        }
        catch (Throwable ex) {
            GeminiUtil.fatalError("Could not parse .classpath ", ex);
        }
        finally {
            GeminiUtil.close(in);
        }
        return null;
    }
}

