/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.jpa.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.eclipse.gemini.jpa.GeminiUtil;
import org.eclipse.gemini.jpa.PUnitInfo;
import org.eclipse.gemini.jpa.proxy.EMFServiceProxyHandler;

public class EMFBuilderServiceProxyHandler
extends EMFServiceProxyHandler
implements InvocationHandler {
    Map<String, Object> emfProps = new HashMap<String, Object>();

    public EMFBuilderServiceProxyHandler(PUnitInfo pUnitInfo, EMFServiceProxyHandler emfService) {
        super(pUnitInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        EntityManagerFactory emf;
        GeminiUtil.debug("EMFBuilderProxy invocation on method ", (Object)method.getName());
        if (method.getName().equals("hashCode")) {
            return this.hashCode();
        }
        if (method.getName().equals("toString")) {
            return this.toString();
        }
        if (method.getName().equals("equals")) {
            return this.equals(args[0]);
        }
        Map props = (Map)args[0];
        if (props != null && (props.get(GeminiUtil.GEMINI_JPA_CREATE_SEPARATE_EMF) != null || props.get("eclipselink.session-name") != null)) {
            if (this.pUnitInfo.getDriverClassName() == null && this.pUnitInfo.getDriverUrl() == null) {
                return super.createEMF(props);
            }
            throw new IllegalArgumentException();
        }
        PUnitInfo pUnitInfo = this.pUnitInfo;
        synchronized (pUnitInfo) {
            emf = this.pUnitInfo.getEmf();
            if (emf != null && !emf.isOpen()) {
                this.syncUnsetEMF();
                this.emfProps.clear();
                emf = null;
            }
        }
        if (emf != null) {
            this.verifyJDBCProperties((String)this.emfProps.get(GeminiUtil.JPA_JDBC_DRIVER_PROPERTY), (String)this.emfProps.get(GeminiUtil.JPA_JDBC_URL_PROPERTY), props);
            if (this.pUnitInfo.isEmfSetByBuilderService()) {
                return emf;
            }
            this.verifyJDBCProperties(this.pUnitInfo.getDriverClassName(), this.pUnitInfo.getDriverUrl(), props);
            return emf;
        }
        return this.syncGetEMFAndSetIfAbsent(true, props);
    }

    @Override
    public EntityManagerFactory createEMF(Map<String, Object> props) {
        this.emfProps = props;
        return super.createEMF(props);
    }

    protected void verifyJDBCProperties(String driver, String driverUrl, Map<String, Object> props) {
        String propUrl;
        String propDriver;
        if (driver != null && (propDriver = (String)props.get(GeminiUtil.JPA_JDBC_DRIVER_PROPERTY)) != null && !driver.equals(propDriver)) {
            throw new IllegalArgumentException();
        }
        if (driverUrl != null && (propUrl = (String)props.get(GeminiUtil.JPA_JDBC_URL_PROPERTY)) != null && !driverUrl.equals(propUrl)) {
            throw new IllegalArgumentException();
        }
    }
}

