/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.File;
import java.io.RandomAccessFile;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvalidSnapshotTest
extends ZKTestCase
implements Watcher {
    private static final Logger LOG = LoggerFactory.getLogger(InvalidSnapshotTest.class);
    private static final String HOSTPORT = "127.0.0.1:" + PortAssignment.unique();
    private static final int CONNECTION_TIMEOUT = 3000;

    @Test
    public void testInvalidSnapshot() throws Exception {
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        SyncRequestProcessor.setSnapCount((int)100);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        Assert.assertTrue((String)"waiting for server being up ", (boolean)ClientBase.waitForServerUp(HOSTPORT, 3000L));
        try (ZooKeeper zk = new ZooKeeper(HOSTPORT, 3000, (Watcher)this);){
            int i = 0;
            while (i < 2000) {
                zk.create("/invalidsnap-" + i, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                ++i;
            }
        }
        f.shutdown();
        Assert.assertTrue((String)"waiting for server to shutdown", (boolean)ClientBase.waitForServerDown(HOSTPORT, 3000L));
        File snapFile = zks.getTxnLogFactory().findMostRecentSnapshot();
        RandomAccessFile raf = new RandomAccessFile(snapFile, "rws");
        raf.setLength(3L);
        raf.close();
        zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        SyncRequestProcessor.setSnapCount((int)100);
        f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        Assert.assertTrue((String)"waiting for server being up ", (boolean)ClientBase.waitForServerUp(HOSTPORT, 3000L));
        zk = new ZooKeeper(HOSTPORT, 20000, (Watcher)this);
        try {
            Assert.assertTrue((String)"the node should exist", (zk.exists("/invalidsnap-1999", false) != null ? 1 : 0) != 0);
            f.shutdown();
            Assert.assertTrue((String)"waiting for server to shutdown", (boolean)ClientBase.waitForServerDown(HOSTPORT, 3000L));
        }
        finally {
            zk.close();
        }
        f.shutdown();
        Assert.assertTrue((String)"waiting for server to shutdown", (boolean)ClientBase.waitForServerDown(HOSTPORT, 3000L));
    }

    public void process(WatchedEvent event) {
    }
}

