/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.WriterAppender;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;

public class QuorumPeerMainTest
extends QuorumPeerTestBase {
    @Test
    public void testQuorum() throws Exception {
        ClientBase.setupTestEnv();
        int CLIENT_PORT_QP1 = PortAssignment.unique();
        int CLIENT_PORT_QP2 = PortAssignment.unique();
        String quorumCfgSection = "server.1=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + "\nserver.2=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique();
        QuorumPeerTestBase.MainThread q1 = new QuorumPeerTestBase.MainThread(1, CLIENT_PORT_QP1, quorumCfgSection);
        QuorumPeerTestBase.MainThread q2 = new QuorumPeerTestBase.MainThread(2, CLIENT_PORT_QP2, quorumCfgSection);
        q1.start();
        q2.start();
        Assert.assertTrue((String)"waiting for server 1 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
        Assert.assertTrue((String)"waiting for server 2 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
        ZooKeeper zk = new ZooKeeper("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        zk.create("/foo_q1", "foobar1".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assert.assertEquals((Object)new String(zk.getData("/foo_q1", null, null)), (Object)"foobar1");
        zk.close();
        zk = new ZooKeeper("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        zk.create("/foo_q2", "foobar2".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assert.assertEquals((Object)new String(zk.getData("/foo_q2", null, null)), (Object)"foobar2");
        zk.close();
        q1.shutdown();
        q2.shutdown();
        Assert.assertTrue((String)"waiting for server 1 down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
        Assert.assertTrue((String)"waiting for server 2 down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
    }

    @Test
    public void testEarlyLeaderAbandonment() throws Exception {
        ClientBase.setupTestEnv();
        int SERVER_COUNT = 3;
        int[] clientPorts = new int[3];
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < 3) {
            clientPorts[i] = PortAssignment.unique();
            sb.append("server." + i + "=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + "\n");
            ++i;
        }
        String quorumCfgSection = sb.toString();
        QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[3];
        ZooKeeper[] zk = new ZooKeeper[3];
        int i2 = 0;
        while (i2 < 3) {
            mt[i2] = new QuorumPeerTestBase.MainThread(i2, clientPorts[i2], quorumCfgSection);
            mt[i2].start();
            zk[i2] = new ZooKeeper("127.0.0.1:" + clientPorts[i2], ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
            ++i2;
        }
        this.waitForAll(zk, ZooKeeper.States.CONNECTED);
        i2 = 0;
        while (i2 < 3) {
            mt[i2].shutdown();
            ++i2;
        }
        this.waitForAll(zk, ZooKeeper.States.CONNECTING);
        i2 = 0;
        while (i2 < 3) {
            mt[i2].start();
            ++i2;
        }
        this.waitForAll(zk, ZooKeeper.States.CONNECTED);
        int leader = -1;
        Map outstanding = null;
        int i222 = 0;
        while (i222 < 3) {
            if (mt[i222].main.quorumPeer.leader == null) {
                mt[i222].shutdown();
            } else {
                leader = i222;
                outstanding = mt[leader].main.quorumPeer.leader.outstandingProposals;
            }
            ++i222;
        }
        try {
            zk[leader].create("/zk" + leader, "zk".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            Assert.fail((String)("create /zk" + leader + " should have failed"));
        }
        catch (KeeperException i222) {
            // empty catch block
        }
        Assert.assertTrue((outstanding.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((Leader.Proposal)outstanding.values().iterator().next()).request.hdr.getType() == 1 ? 1 : 0) != 0);
        Thread.sleep(1000L);
        mt[leader].shutdown();
        this.waitForAll(zk, ZooKeeper.States.CONNECTING);
        int i3 = 0;
        while (i3 < 3) {
            if (i3 != leader) {
                mt[i3].start();
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < 3) {
            if (i3 != leader) {
                this.waitForOne(zk[i3], ZooKeeper.States.CONNECTED);
                zk[i3].create("/zk" + i3, "zk".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            ++i3;
        }
        mt[leader].start();
        this.waitForAll(zk, ZooKeeper.States.CONNECTED);
        i3 = 0;
        while (i3 < 3) {
            int j = 0;
            while (j < 3) {
                if (i3 == leader) {
                    Assert.assertTrue((String)(String.valueOf(j == leader ? "Leader (" + leader + ")" : "Follower " + j) + " should not have /zk" + i3), (zk[j].exists("/zk" + i3, false) == null ? 1 : 0) != 0);
                } else {
                    Assert.assertTrue((String)(String.valueOf(j == leader ? "Leader (" + leader + ")" : "Follower " + j) + " does not have /zk" + i3), (zk[j].exists("/zk" + i3, false) != null ? 1 : 0) != 0);
                }
                ++j;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < 3) {
            zk[i3].close();
            ++i3;
        }
        i3 = 0;
        while (i3 < 3) {
            mt[i3].shutdown();
            ++i3;
        }
    }

    @Test
    public void testHighestZxidJoinLate() throws Exception {
        int numServers = 3;
        Servers svrs = this.LaunchServers(numServers);
        String path = "/hzxidtest";
        int leader = -1;
        int i = 0;
        while (i < numServers) {
            if (svrs.mt[i].main.quorumPeer.leader != null) {
                leader = i;
            }
            ++i;
        }
        Assert.assertTrue((String)"There should be a leader", (leader >= 0 ? 1 : 0) != 0);
        int nonleader = (leader + 1) % numServers;
        byte[] input = new byte[]{1};
        svrs.zk[leader].create(String.valueOf(path) + leader, input, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        svrs.zk[leader].create(String.valueOf(path) + nonleader, input, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        byte[] output = svrs.zk[leader].getData(String.valueOf(path) + nonleader, false, null);
        int i2 = 0;
        while (i2 < numServers) {
            if (i2 != leader) {
                svrs.mt[i2].shutdown();
            }
            ++i2;
        }
        input[0] = 2;
        svrs.zk[leader].setData(String.valueOf(path) + leader, input, -1, null, null);
        Thread.sleep(500L);
        svrs.mt[leader].shutdown();
        System.gc();
        this.waitForAll(svrs.zk, ZooKeeper.States.CONNECTING);
        i2 = 0;
        while (i2 < numServers) {
            if (i2 != leader) {
                svrs.mt[i2].start();
            }
            ++i2;
        }
        this.waitForOne(svrs.zk[nonleader], ZooKeeper.States.CONNECTED);
        output = svrs.zk[nonleader].getData(String.valueOf(path) + leader, false, null);
        Assert.assertEquals((String)"Expecting old value 1 since 2 isn't committed yet", (long)output[0], (long)1L);
        svrs.zk[nonleader].setData(String.valueOf(path) + nonleader, input, -1);
        svrs.mt[leader].start();
        this.waitForOne(svrs.zk[leader], ZooKeeper.States.CONNECTED);
        output = svrs.zk[leader].getData(String.valueOf(path) + leader, false, null);
        Assert.assertEquals((String)"Validating that the deposed leader has rolled back that change it had written", (long)output[0], (long)1L);
        output = svrs.zk[leader].getData(String.valueOf(path) + nonleader, false, null);
        Assert.assertEquals((String)"Validating that the deposed leader caught up on changes it missed", (long)output[0], (long)2L);
    }

    private void waitForOne(ZooKeeper zk, ZooKeeper.States state) throws InterruptedException {
        while (zk.getState() != state) {
            Thread.sleep(500L);
        }
    }

    private void waitForAll(ZooKeeper[] zks, ZooKeeper.States state) throws InterruptedException {
        int iterations = 10;
        boolean someoneNotConnected = true;
        while (someoneNotConnected) {
            if (iterations-- == 0) {
                ClientBase.logAllStackTraces();
                throw new RuntimeException("Waiting too long");
            }
            someoneNotConnected = false;
            ZooKeeper[] zooKeeperArray = zks;
            int n = zks.length;
            int n2 = 0;
            while (n2 < n) {
                ZooKeeper zk = zooKeeperArray[n2];
                if (zk.getState() != state) {
                    someoneNotConnected = true;
                }
                ++n2;
            }
            Thread.sleep(1000L);
        }
    }

    private Servers LaunchServers(int numServers) throws IOException, InterruptedException {
        int SERVER_COUNT = numServers;
        Servers svrs = new Servers();
        int[] clientPorts = new int[SERVER_COUNT];
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < SERVER_COUNT) {
            clientPorts[i] = PortAssignment.unique();
            sb.append("server." + i + "=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + "\n");
            ++i;
        }
        String quorumCfgSection = sb.toString();
        QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[SERVER_COUNT];
        ZooKeeper[] zk = new ZooKeeper[SERVER_COUNT];
        int i2 = 0;
        while (i2 < SERVER_COUNT) {
            mt[i2] = new QuorumPeerTestBase.MainThread(i2, clientPorts[i2], quorumCfgSection);
            mt[i2].start();
            zk[i2] = new ZooKeeper("127.0.0.1:" + clientPorts[i2], ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
            ++i2;
        }
        this.waitForAll(zk, ZooKeeper.States.CONNECTED);
        svrs.mt = mt;
        svrs.zk = zk;
        return svrs;
    }

    @Test
    public void testBadPeerAddressInQuorum() throws Exception {
        String line;
        ClientBase.setupTestEnv();
        Layout layout = Logger.getRootLogger().getAppender("CONSOLE").getLayout();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        WriterAppender appender = new WriterAppender(layout, (OutputStream)os);
        appender.setThreshold((Priority)Level.WARN);
        Logger qlogger = Logger.getLogger((String)"org.apache.zookeeper.server.quorum");
        qlogger.addAppender((Appender)appender);
        try {
            int CLIENT_PORT_QP1 = PortAssignment.unique();
            int CLIENT_PORT_QP2 = PortAssignment.unique();
            String quorumCfgSection = "server.1=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + "\nserver.2=fee.fii.foo.fum:" + PortAssignment.unique() + ":" + PortAssignment.unique();
            QuorumPeerTestBase.MainThread q1 = new QuorumPeerTestBase.MainThread(1, CLIENT_PORT_QP1, quorumCfgSection);
            q1.start();
            boolean isup = ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP1, 5000L);
            Assert.assertFalse((String)"Server never came up", (boolean)isup);
            q1.shutdown();
            Assert.assertTrue((String)"waiting for server 1 down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
        }
        finally {
            qlogger.removeAppender((Appender)appender);
        }
        LineNumberReader r = new LineNumberReader(new StringReader(os.toString()));
        boolean found = false;
        Pattern p = Pattern.compile(".*Cannot open channel to .* at election address .*");
        while ((line = r.readLine()) != null) {
            found = p.matcher(line).matches();
            if (found) break;
        }
        Assert.assertTrue((String)"complains about host", (boolean)found);
    }

    @Test
    public void testInconsistentPeerType() throws Exception {
        String line;
        ClientBase.setupTestEnv();
        Layout layout = Logger.getRootLogger().getAppender("CONSOLE").getLayout();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        WriterAppender appender = new WriterAppender(layout, (OutputStream)os);
        appender.setThreshold((Priority)Level.INFO);
        Logger qlogger = Logger.getLogger((String)"org.apache.zookeeper.server.quorum");
        qlogger.addAppender((Appender)appender);
        try {
            int CLIENT_PORT_QP1 = PortAssignment.unique();
            int CLIENT_PORT_QP2 = PortAssignment.unique();
            int CLIENT_PORT_QP3 = PortAssignment.unique();
            String quorumCfgSection = "server.1=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + "\nserver.2=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + "\nserver.3=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":observer";
            QuorumPeerTestBase.MainThread q1 = new QuorumPeerTestBase.MainThread(1, CLIENT_PORT_QP1, quorumCfgSection);
            QuorumPeerTestBase.MainThread q2 = new QuorumPeerTestBase.MainThread(2, CLIENT_PORT_QP2, quorumCfgSection);
            QuorumPeerTestBase.MainThread q3 = new QuorumPeerTestBase.MainThread(3, CLIENT_PORT_QP3, quorumCfgSection);
            q1.start();
            q2.start();
            q3.start();
            Assert.assertTrue((String)"waiting for server 1 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
            Assert.assertTrue((String)"waiting for server 2 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
            Assert.assertTrue((String)"waiting for server 3 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP3, ClientBase.CONNECTION_TIMEOUT));
            q1.shutdown();
            q2.shutdown();
            q3.shutdown();
            Assert.assertTrue((String)"waiting for server 1 down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
            Assert.assertTrue((String)"waiting for server 2 down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
            Assert.assertTrue((String)"waiting for server 3 down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP3, ClientBase.CONNECTION_TIMEOUT));
        }
        finally {
            qlogger.removeAppender((Appender)appender);
        }
        LineNumberReader r = new LineNumberReader(new StringReader(os.toString()));
        boolean warningPresent = false;
        boolean defaultedToObserver = false;
        Pattern pWarn = Pattern.compile(".*Peer type from servers list.* doesn't match peerType.*");
        Pattern pObserve = Pattern.compile(".*OBSERVING.*");
        while ((line = r.readLine()) != null) {
            if (pWarn.matcher(line).matches()) {
                warningPresent = true;
            }
            if (pObserve.matcher(line).matches()) {
                defaultedToObserver = true;
            }
            if (warningPresent && defaultedToObserver) break;
        }
        Assert.assertTrue((String)"Should warn about inconsistent peer type", (warningPresent && defaultedToObserver ? 1 : 0) != 0);
    }

    @Test
    public void testBadPackets() throws Exception {
        ClientBase.setupTestEnv();
        int CLIENT_PORT_QP1 = PortAssignment.unique();
        int CLIENT_PORT_QP2 = PortAssignment.unique();
        int electionPort1 = PortAssignment.unique();
        int electionPort2 = PortAssignment.unique();
        String quorumCfgSection = "server.1=127.0.0.1:" + PortAssignment.unique() + ":" + electionPort1 + "\nserver.2=127.0.0.1:" + PortAssignment.unique() + ":" + electionPort2;
        QuorumPeerTestBase.MainThread q1 = new QuorumPeerTestBase.MainThread(1, CLIENT_PORT_QP1, quorumCfgSection);
        QuorumPeerTestBase.MainThread q2 = new QuorumPeerTestBase.MainThread(2, CLIENT_PORT_QP2, quorumCfgSection);
        q1.start();
        q2.start();
        Assert.assertTrue((String)"waiting for server 1 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
        Assert.assertTrue((String)"waiting for server 2 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
        byte[] b = new byte[4];
        int length = 0x40000000;
        ByteBuffer buff = ByteBuffer.wrap(b);
        buff.putInt(length);
        buff.position(0);
        SocketChannel s = SocketChannel.open(new InetSocketAddress("127.0.0.1", electionPort1));
        s.write(buff);
        s.close();
        buff.position(0);
        s = SocketChannel.open(new InetSocketAddress("127.0.0.1", electionPort2));
        s.write(buff);
        s.close();
        ZooKeeper zk = new ZooKeeper("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        zk.create("/foo_q1", "foobar1".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assert.assertEquals((Object)new String(zk.getData("/foo_q1", null, null)), (Object)"foobar1");
        zk.close();
        q1.shutdown();
        q2.shutdown();
    }

    @Test
    public void testQuorumDefaults() throws Exception {
        String line;
        ClientBase.setupTestEnv();
        Layout layout = Logger.getRootLogger().getAppender("CONSOLE").getLayout();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        WriterAppender appender = new WriterAppender(layout, (OutputStream)os);
        appender.setImmediateFlush(true);
        appender.setThreshold((Priority)Level.INFO);
        Logger zlogger = Logger.getLogger((String)"org.apache.zookeeper");
        zlogger.addAppender((Appender)appender);
        try {
            int CLIENT_PORT_QP1 = PortAssignment.unique();
            int CLIENT_PORT_QP2 = PortAssignment.unique();
            String quorumCfgSection = "server.1=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + "\nserver.2=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique();
            QuorumPeerTestBase.MainThread q1 = new QuorumPeerTestBase.MainThread(1, CLIENT_PORT_QP1, quorumCfgSection);
            QuorumPeerTestBase.MainThread q2 = new QuorumPeerTestBase.MainThread(2, CLIENT_PORT_QP2, quorumCfgSection);
            q1.start();
            q2.start();
            Assert.assertTrue((String)"waiting for server 1 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
            Assert.assertTrue((String)"waiting for server 2 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
            q1.shutdown();
            q2.shutdown();
            Assert.assertTrue((String)"waiting for server 1 down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
            Assert.assertTrue((String)"waiting for server 2 down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
        }
        finally {
            zlogger.removeAppender((Appender)appender);
        }
        os.close();
        LineNumberReader r = new LineNumberReader(new StringReader(os.toString()));
        boolean found = false;
        Pattern p = Pattern.compile(".*FastLeaderElection.*");
        while ((line = r.readLine()) != null) {
            found = p.matcher(line).matches();
            if (found) break;
        }
        Assert.assertTrue((String)"fastleaderelection used", (boolean)found);
    }

    @Test
    public void testQuorumPeerExitTime() throws Exception {
        long maxwait = 3000L;
        int CLIENT_PORT_QP1 = PortAssignment.unique();
        String quorumCfgSection = "server.1=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + "\nserver.2=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique();
        QuorumPeerTestBase.MainThread q1 = new QuorumPeerTestBase.MainThread(1, CLIENT_PORT_QP1, quorumCfgSection);
        q1.start();
        Thread.sleep(30000L);
        long start = System.currentTimeMillis();
        q1.shutdown();
        long end = System.currentTimeMillis();
        if (end - start > maxwait) {
            Assert.fail((String)("QuorumPeer took " + (end - start) + " to shutdown, expected " + maxwait));
        }
    }

    private class Servers {
        QuorumPeerTestBase.MainThread[] mt;
        ZooKeeper[] zk;

        private Servers() {
        }
    }
}

