/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.quorum.QuorumCnxManager;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.FLENewEpochTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CnxManagerTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(FLENewEpochTest.class);
    protected static final int THRESHOLD = 4;
    int count;
    HashMap<Long, QuorumPeer.QuorumServer> peers;
    File[] peerTmpdir;
    int[] peerQuorumPort;
    int[] peerClientPort;

    @Before
    public void setUp() throws Exception {
        this.count = 3;
        this.peers = new HashMap(this.count);
        this.peerTmpdir = new File[this.count];
        this.peerQuorumPort = new int[this.count];
        this.peerClientPort = new int[this.count];
        int i = 0;
        while (i < this.count) {
            this.peerQuorumPort[i] = PortAssignment.unique();
            this.peerClientPort[i] = PortAssignment.unique();
            this.peers.put(Long.valueOf(i), new QuorumPeer.QuorumServer((long)i, new InetSocketAddress(this.peerQuorumPort[i]), new InetSocketAddress(PortAssignment.unique())));
            this.peerTmpdir[i] = ClientBase.createTmpDir();
            ++i;
        }
    }

    ByteBuffer createMsg(int state, long leader, long zxid, long epoch) {
        byte[] requestBytes = new byte[28];
        ByteBuffer requestBuffer = ByteBuffer.wrap(requestBytes);
        requestBuffer.clear();
        requestBuffer.putInt(state);
        requestBuffer.putLong(leader);
        requestBuffer.putLong(zxid);
        requestBuffer.putLong(epoch);
        return requestBuffer;
    }

    @Test
    public void testCnxManager() throws Exception {
        CnxManagerThread thread = new CnxManagerThread();
        thread.start();
        QuorumPeer peer = new QuorumPeer(this.peers, this.peerTmpdir[1], this.peerTmpdir[1], this.peerClientPort[1], 3, 1L, 1000, 2, 2);
        QuorumCnxManager cnxManager = new QuorumCnxManager(peer);
        QuorumCnxManager.Listener listener = cnxManager.listener;
        if (listener != null) {
            listener.start();
        } else {
            LOG.error("Null listener when initializing cnx manager");
        }
        cnxManager.toSend(new Long(0L), this.createMsg(QuorumPeer.ServerState.LOOKING.ordinal(), 1L, -1L, 1L));
        QuorumCnxManager.Message m = null;
        int numRetries = 1;
        while (m == null && numRetries++ <= 4) {
            m = cnxManager.pollRecvQueue(3000L, TimeUnit.MILLISECONDS);
            if (m != null) continue;
            cnxManager.connectAll();
        }
        Assert.assertTrue((String)"Exceeded number of retries", (numRetries <= 4 ? 1 : 0) != 0);
        thread.join(5000L);
        if (thread.isAlive()) {
            Assert.fail((String)"Thread didn't join");
        } else if (thread.failed) {
            Assert.fail((String)"Did not receive expected message");
        }
    }

    @Test
    public void testCnxManagerTimeout() throws Exception {
        Random rand = new Random();
        byte b = (byte)rand.nextInt();
        int deadPort = PortAssignment.unique();
        String deadAddress = new String("10.1.1." + b);
        LOG.info("This is the dead address I'm trying: " + deadAddress);
        this.peers.put(2L, new QuorumPeer.QuorumServer(2L, new InetSocketAddress(deadAddress, deadPort), new InetSocketAddress(deadAddress, PortAssignment.unique())));
        this.peerTmpdir[2] = ClientBase.createTmpDir();
        QuorumPeer peer = new QuorumPeer(this.peers, this.peerTmpdir[1], this.peerTmpdir[1], this.peerClientPort[1], 3, 1L, 1000, 2, 2);
        QuorumCnxManager cnxManager = new QuorumCnxManager(peer);
        QuorumCnxManager.Listener listener = cnxManager.listener;
        if (listener != null) {
            listener.start();
        } else {
            LOG.error("Null listener when initializing cnx manager");
        }
        long begin = System.currentTimeMillis();
        cnxManager.toSend(new Long(2L), this.createMsg(QuorumPeer.ServerState.LOOKING.ordinal(), 1L, -1L, 1L));
        long end = System.currentTimeMillis();
        if (end - begin > 6000L) {
            Assert.fail((String)"Waited more than necessary");
        }
    }

    @Test
    public void testCnxManagerSpinLock() throws Exception {
        QuorumPeer peer = new QuorumPeer(this.peers, this.peerTmpdir[1], this.peerTmpdir[1], this.peerClientPort[1], 3, 1L, 1000, 2, 2);
        QuorumCnxManager cnxManager = new QuorumCnxManager(peer);
        QuorumCnxManager.Listener listener = cnxManager.listener;
        if (listener != null) {
            listener.start();
        } else {
            LOG.error("Null listener when initializing cnx manager");
        }
        int port = this.peers.get((Object)Long.valueOf((long)peer.getId())).electionAddr.getPort();
        LOG.info("Election port: " + port);
        InetSocketAddress addr = new InetSocketAddress(port);
        Thread.sleep(1000L);
        SocketChannel sc = SocketChannel.open();
        sc.socket().connect(this.peers.get((Object)new Long((long)1L)).electionAddr, 5000);
        byte[] msgBytes = new byte[8];
        ByteBuffer msgBuffer = ByteBuffer.wrap(msgBytes);
        msgBuffer.putLong(new Long(2L));
        msgBuffer.position(0);
        sc.write(msgBuffer);
        msgBuffer = ByteBuffer.wrap(new byte[4]);
        msgBuffer.putInt(-20);
        msgBuffer.position(0);
        sc.write(msgBuffer);
        Thread.sleep(1000L);
        try {
            int i = 0;
            while (i < 100) {
                msgBuffer.position(0);
                sc.write(msgBuffer);
                ++i;
            }
            Assert.fail((String)"Socket has not been closed");
        }
        catch (Exception e) {
            LOG.info("Socket has been closed as expected");
        }
        peer.shutdown();
        cnxManager.halt();
    }

    @Test
    public void testSocketTimeout() throws Exception {
        QuorumPeer peer = new QuorumPeer(this.peers, this.peerTmpdir[1], this.peerTmpdir[1], this.peerClientPort[1], 3, 1L, 2000, 2, 2);
        QuorumCnxManager cnxManager = new QuorumCnxManager(peer);
        QuorumCnxManager.Listener listener = cnxManager.listener;
        if (listener != null) {
            listener.start();
        } else {
            LOG.error("Null listener when initializing cnx manager");
        }
        int port = this.peers.get((Object)Long.valueOf((long)peer.getId())).electionAddr.getPort();
        LOG.info("Election port: " + port);
        InetSocketAddress addr = new InetSocketAddress(port);
        Thread.sleep(1000L);
        Socket sock = new Socket();
        sock.connect(this.peers.get((Object)new Long((long)1L)).electionAddr, 5000);
        long begin = System.currentTimeMillis();
        cnxManager.receiveConnection(sock);
        long end = System.currentTimeMillis();
        if (end - begin > (long)(peer.getSyncLimit() * peer.getTickTime() + 500)) {
            Assert.fail((String)"Waited more than necessary");
        }
    }

    @Test
    public void testWorkerThreads() throws Exception {
        ArrayList<QuorumPeer> peerList = new ArrayList<QuorumPeer>();
        int sid = 0;
        while (sid < 3) {
            QuorumPeer peer = new QuorumPeer(this.peers, this.peerTmpdir[sid], this.peerTmpdir[sid], this.peerClientPort[sid], 3, (long)sid, 1000, 2, 2);
            LOG.info("Starting peer " + peer.getId());
            peer.start();
            peerList.add(sid, peer);
            ++sid;
        }
        String failure = this.verifyThreadCount(peerList, 4L);
        if (failure != null) {
            Assert.fail((String)failure);
        }
        int myid = 0;
        while (myid < 3) {
            int i = 0;
            while (i < 5) {
                QuorumPeer peer = peerList.get(myid);
                LOG.info("Round " + i + ", halting peer " + peer.getId());
                peer.shutdown();
                peerList.remove(myid);
                failure = this.verifyThreadCount(peerList, 2L);
                if (failure != null) {
                    Assert.fail((String)failure);
                }
                peer = new QuorumPeer(this.peers, this.peerTmpdir[myid], this.peerTmpdir[myid], this.peerClientPort[myid], 3, (long)myid, 1000, 2, 2);
                LOG.info("Round " + i + ", restarting peer " + peer.getId());
                peer.start();
                peerList.add(myid, peer);
                failure = this.verifyThreadCount(peerList, 4L);
                if (failure != null) {
                    Assert.fail((String)failure);
                }
                ++i;
            }
            ++myid;
        }
    }

    public String verifyThreadCount(ArrayList<QuorumPeer> peerList, long ecnt) throws InterruptedException {
        String failure = null;
        int i = 0;
        while (i < 480) {
            Thread.sleep(500L);
            failure = this._verifyThreadCount(peerList, ecnt);
            if (failure == null) {
                return null;
            }
            ++i;
        }
        return failure;
    }

    public String _verifyThreadCount(ArrayList<QuorumPeer> peerList, long ecnt) {
        int myid = 0;
        while (myid < peerList.size()) {
            QuorumPeer peer = peerList.get(myid);
            QuorumCnxManager cnxManager = peer.getQuorumCnxManager();
            long cnt = cnxManager.getThreadCount();
            if (cnt != ecnt) {
                return new String(new Date() + " Incorrect number of Worker threads for sid=" + myid + " expected " + ecnt + " found " + cnt);
            }
            ++myid;
        }
        return null;
    }

    class CnxManagerThread
    extends Thread {
        boolean failed = false;

        CnxManagerThread() {
        }

        @Override
        public void run() {
            try {
                QuorumPeer peer = new QuorumPeer(CnxManagerTest.this.peers, CnxManagerTest.this.peerTmpdir[0], CnxManagerTest.this.peerTmpdir[0], CnxManagerTest.this.peerClientPort[0], 3, 0L, 1000, 2, 2);
                QuorumCnxManager cnxManager = new QuorumCnxManager(peer);
                QuorumCnxManager.Listener listener = cnxManager.listener;
                if (listener != null) {
                    listener.start();
                } else {
                    LOG.error("Null listener when initializing cnx manager");
                }
                long sid = 1L;
                cnxManager.toSend(Long.valueOf(sid), CnxManagerTest.this.createMsg(QuorumPeer.ServerState.LOOKING.ordinal(), 0L, -1L, 1L));
                QuorumCnxManager.Message m = null;
                int numRetries = 1;
                while (m == null && numRetries++ <= 4) {
                    m = cnxManager.pollRecvQueue(3000L, TimeUnit.MILLISECONDS);
                    if (m != null) continue;
                    cnxManager.connectAll();
                }
                if (numRetries > 4) {
                    this.failed = true;
                    return;
                }
                cnxManager.testInitiateConnection(sid);
                m = cnxManager.pollRecvQueue(3000L, TimeUnit.MILLISECONDS);
                if (m == null) {
                    this.failed = true;
                    return;
                }
            }
            catch (Exception e) {
                LOG.error("Exception while running mock thread", (Throwable)e);
                Assert.fail((String)"Unexpected exception");
            }
        }
    }
}

