/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.test.ClientBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiTransactionTest
extends ZKTestCase
implements Watcher {
    private static final Logger LOG = Logger.getLogger(MultiTransactionTest.class);
    private static final String HOSTPORT = "127.0.0.1:" + PortAssignment.unique();
    private ZooKeeper zk;
    private ServerCnxnFactory serverFactory;

    public void process(WatchedEvent event) {
    }

    @Before
    public void setupZk() throws Exception {
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        SyncRequestProcessor.setSnapCount((int)150);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        this.serverFactory = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        this.serverFactory.startup(zks);
        LOG.info((Object)"starting up the zookeeper server .. waiting");
        Assert.assertTrue((String)"waiting for server being up", (boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
        this.zk = new ZooKeeper(HOSTPORT, ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
    }

    @After
    public void shutdownServer() throws Exception {
        this.zk.close();
        this.serverFactory.shutdown();
    }

    @Test
    public void testCreate() throws Exception {
        List results = new ArrayList();
        results = this.zk.multi(Arrays.asList(Op.create((String)"/multi0", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.create((String)"/multi1", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.create((String)"/multi2", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT)));
        this.zk.getData("/multi0", false, null);
        this.zk.getData("/multi1", false, null);
        this.zk.getData("/multi2", false, null);
    }

    @Test
    public void testCreateDelete() throws Exception {
        this.zk.multi(Arrays.asList(Op.create((String)"/multi", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.delete((String)"/multi", (int)0)));
        Assert.assertNull((Object)this.zk.exists("/multi", null));
    }

    @Test
    public void testInvalidVersion() throws Exception {
        try {
            this.zk.multi(Arrays.asList(Op.create((String)"/multi", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.delete((String)"/multi", (int)1)));
            Assert.fail((String)"delete /multi should have failed");
        }
        catch (KeeperException keeperException) {
            // empty catch block
        }
    }

    @Test
    public void testNestedCreate() throws Exception {
        this.zk.multi(Arrays.asList(Op.create((String)"/multi", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.create((String)"/multi/a", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.create((String)"/multi/a/1", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.delete((String)"/multi/a/1", (int)0), Op.delete((String)"/multi/a", (int)0), Op.delete((String)"/multi", (int)0)));
        Assert.assertNull((Object)this.zk.exists("/multi/a/1", null));
        Assert.assertNull((Object)this.zk.exists("/multi/a", null));
        Assert.assertNull((Object)this.zk.exists("/multi", null));
    }

    @Test
    public void testSetData() throws Exception {
        String[] names = new String[]{"/multi0", "/multi1", "/multi2"};
        ArrayList<Op> ops = new ArrayList<Op>();
        int i = 0;
        while (i < names.length) {
            ops.add(Op.create((String)names[i], (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT));
            ops.add(Op.setData((String)names[i], (byte[])names[i].getBytes(), (int)0));
            ++i;
        }
        this.zk.multi(ops);
        i = 0;
        while (i < names.length) {
            Assert.assertArrayEquals((byte[])names[i].getBytes(), (byte[])this.zk.getData(names[i], false, null));
            ++i;
        }
    }

    @Test
    public void testUpdateConflict() throws Exception {
        Assert.assertNull((Object)this.zk.exists("/multi", null));
        try {
            this.zk.multi(Arrays.asList(Op.create((String)"/multi", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.setData((String)"/multi", (byte[])"X".getBytes(), (int)0), Op.setData((String)"/multi", (byte[])"Y".getBytes(), (int)0)));
            Assert.fail((String)"Should have thrown a KeeperException for invalid version");
        }
        catch (KeeperException e) {
            LOG.error((Object)("STACKTRACE: " + (Object)((Object)e)));
        }
        Assert.assertNull((Object)this.zk.exists("/multi", null));
        this.zk.multi(Arrays.asList(Op.create((String)"/multi", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.setData((String)"/multi", (byte[])"X".getBytes(), (int)0), Op.setData((String)"/multi", (byte[])"Y".getBytes(), (int)1)));
        Assert.assertArrayEquals((byte[])this.zk.getData("/multi", false, null), (byte[])"Y".getBytes());
    }

    @Test
    public void TestDeleteUpdateConflict() throws Exception {
        try {
            this.zk.multi(Arrays.asList(Op.create((String)"/multi", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.delete((String)"/multi", (int)0), Op.setData((String)"/multi", (byte[])"Y".getBytes(), (int)0)));
            Assert.fail((String)"/multi should have been deleted so setData should have failed");
        }
        catch (KeeperException keeperException) {
            // empty catch block
        }
        Assert.assertNull((Object)this.zk.exists("/multi", null));
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void TestGetResults() throws Exception {
        block3: {
            try {
                this.zk.multi(Arrays.asList(new Op[]{Op.create((String)"/multi", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.delete((String)"/multi", (int)0), Op.setData((String)"/multi", (byte[])"Y".getBytes(), (int)0), Op.create((String)"/foo", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT)}));
                Assert.fail((String)"/multi should have been deleted so setData should have failed");
                break block3;
            }
            catch (KeeperException e) {
                Assert.assertNull((Object)this.zk.exists("/multi", null));
                ** for (r : e.getResults())
            }
lbl-1000:
            // 1 sources

            {
                MultiTransactionTest.LOG.info((Object)("RESULT==> " + r));
                if (!(r instanceof OpResult.ErrorResult)) continue;
                er = (OpResult.ErrorResult)r;
                MultiTransactionTest.LOG.info((Object)("ERROR RESULT: " + er + " ERR=>" + KeeperException.Code.get((int)er.getErr())));
                continue;
            }
        }
    }
}

