/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.eclipselink.internal;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.common.internal.services.IServiceProxyChangeListener;
import org.eclipse.gyrex.common.internal.services.ServiceProxy;
import org.eclipse.gyrex.common.services.IServiceProxy;
import org.eclipse.gyrex.common.services.ServiceNotAvailableException;
import org.eclipse.gyrex.persistence.eclipselink.EclipseLinkRepository;
import org.eclipse.gyrex.persistence.eclipselink.internal.EclipseLinkActivator;
import org.eclipse.gyrex.persistence.eclipselink.internal.EclipseLinkRepositoryMetrics;
import org.eclipse.gyrex.persistence.storage.content.RepositoryContentType;
import org.eclipse.gyrex.persistence.storage.provider.RepositoryProvider;
import org.eclipse.gyrex.persistence.storage.settings.IRepositoryPreferences;
import org.osgi.service.jdbc.DataSourceFactory;
import org.osgi.service.jpa.EntityManagerFactoryBuilder;

public class EclipseLinkRepositoryImpl
extends EclipseLinkRepository {
    private final IRepositoryPreferences repositoryPreferences;
    private final ConcurrentMap<RepositoryContentType, WeakReference<EntityManagerFactory>> emfCacheByContentType = new ConcurrentHashMap<RepositoryContentType, WeakReference<EntityManagerFactory>>();

    static void closeQuietly(DataSource ds) {
        try {
            Method closeMethod = ds.getClass().getMethod("close", new Class[0]);
            closeMethod.invoke((Object)ds, new Object[0]);
        }
        catch (Exception exception) {}
    }

    public EclipseLinkRepositoryImpl(String repositoryId, RepositoryProvider repositoryProvider, IRepositoryPreferences repositoryPreferences) {
        super(repositoryId, repositoryProvider, new EclipseLinkRepositoryMetrics(EclipseLinkRepositoryImpl.createMetricsId((RepositoryProvider)repositoryProvider, (String)repositoryId), repositoryId, repositoryProvider, "new", "created"));
        this.repositoryPreferences = repositoryPreferences;
    }

    private DataSource createDataSource(DataSourceFactory dataSourceFactory) throws Exception {
        Properties dataSourceProperties = new Properties();
        dataSourceProperties.put("dataSourceName", this.getRepositoryId());
        dataSourceProperties.put("description", String.format("DataSource for repository %s", this.getRepositoryId()));
        String[] stringArray = this.repositoryPreferences.getKeys("dataSourceProperties");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            dataSourceProperties.put(key, this.repositoryPreferences.get(String.format("dataSourceProperties//%s", key), null));
            ++n2;
        }
        return dataSourceFactory.createDataSource(dataSourceProperties);
    }

    protected EntityManagerFactory createEntityManagerFactory(RepositoryContentType contentType) {
        DataSourceFactory dataSourceFactory;
        IServiceProxy dsFactoryServiceProxy;
        EntityManagerFactoryBuilder builder;
        IServiceProxy builderServiceProxy;
        if (!StringUtils.equals((String)EclipseLinkRepository.class.getName(), (String)contentType.getRepositoryTypeName())) {
            throw new IllegalArgumentException(String.format("Incompatible content type specified. EclipseLink Repository type expected but the specified type expects %s.", contentType.getRepositoryTypeName()));
        }
        String unitName = contentType.getParameter("persistenceUnitName");
        if (unitName == null) {
            unitName = contentType.getMediaTypeSubType();
        }
        try {
            builderServiceProxy = EclipseLinkActivator.getInstance().getServiceHelper().trackService(EntityManagerFactoryBuilder.class, String.format("(&(objectClass=%s)(%s=%s))", EntityManagerFactoryBuilder.class.getName(), "osgi.unit.name", unitName));
            builder = (EntityManagerFactoryBuilder)builderServiceProxy.getService();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid content type specified. The persistence unit name (%s) is invalid. %s", unitName, e.getMessage()), e);
        }
        catch (ServiceNotAvailableException e) {
            throw new IllegalStateException(String.format("No EntityManagerFactoryBuilder service available for content type (%s).", contentType), e);
        }
        String driver = this.repositoryPreferences.get("osgi.jdbc.driver.class", null);
        if (driver == null) {
            throw new IllegalStateException(String.format("No database driver configured for repository '%s'.", this.getRepositoryId()));
        }
        try {
            dsFactoryServiceProxy = EclipseLinkActivator.getInstance().getServiceHelper().trackService(DataSourceFactory.class, String.format("(&(objectClass=%s)(osgi.jdbc.driver.class=%s))", DataSourceFactory.class.getName(), driver));
            dataSourceFactory = (DataSourceFactory)dsFactoryServiceProxy.getService();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(String.format("The configured database driver (%s) is invalid. %s", driver, e.getMessage()), e);
        }
        catch (ServiceNotAvailableException e) {
            throw new IllegalStateException(String.format("No DataSourceFactory service available for database driver (%s).", driver), e);
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        DataSource dataSource = null;
        try {
            dataSource = this.createDataSource(dataSourceFactory);
            props.put("javax.persistence.transactionType", "RESOURCE_LOCAL");
            props.put("javax.persistence.nonJtaDataSource", dataSource);
            props.put("eclipselink.session-name", this.getRepositoryId());
            props.put("eclipselink.logging.logger", "JavaLogger");
            EntityManagerFactory entityManagerFactory = builder.createEntityManagerFactory(props);
            EMFDisposer emfDisposer = new EMFDisposer(entityManagerFactory, contentType);
            ((ServiceProxy)builderServiceProxy).addChangeListener((IServiceProxyChangeListener)emfDisposer, (Object)builder);
            ((ServiceProxy)dsFactoryServiceProxy).addChangeListener((IServiceProxyChangeListener)emfDisposer, (Object)dataSourceFactory);
            return entityManagerFactory;
        }
        catch (Exception e) {
            EclipseLinkRepositoryImpl.closeQuietly(dataSource);
            throw new IllegalStateException(String.format("Unable to create EntityManagerFactory for persistence unit name (%s) repository (%s). %s", unitName, this.getRepositoryId(), e.getMessage()), e);
        }
    }

    protected void doClose() {
        super.doClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntityManagerFactory getEntityManagerFactory(RepositoryContentType contentType) {
        EntityManagerFactory factory;
        WeakReference factoryRef = (WeakReference)this.emfCacheByContentType.get(contentType);
        EntityManagerFactory entityManagerFactory = factory = factoryRef != null ? (EntityManagerFactory)factoryRef.get() : null;
        if (factory == null || !factory.isOpen()) {
            ConcurrentMap<RepositoryContentType, WeakReference<EntityManagerFactory>> concurrentMap = this.emfCacheByContentType;
            synchronized (concurrentMap) {
                factoryRef = (WeakReference)this.emfCacheByContentType.get(contentType);
                EntityManagerFactory entityManagerFactory2 = factory = factoryRef != null ? (EntityManagerFactory)factoryRef.get() : null;
                if (factory == null || !factory.isOpen()) {
                    factory = this.createEntityManagerFactory(contentType);
                    this.emfCacheByContentType.put(contentType, new WeakReference<EntityManagerFactory>(factory));
                }
            }
        }
        return factory;
    }

    private class EMFDisposer
    implements IServiceProxyChangeListener {
        private final WeakReference<EntityManagerFactory> entityManagerFactory;
        private final RepositoryContentType contentType;

        public EMFDisposer(EntityManagerFactory entityManagerFactory, RepositoryContentType contentType) {
            this.contentType = contentType;
            this.entityManagerFactory = new WeakReference<EntityManagerFactory>(entityManagerFactory);
        }

        public boolean serviceChanged(IServiceProxy<?> proxy) {
            EclipseLinkRepositoryImpl.this.emfCacheByContentType.remove(this.contentType);
            EntityManagerFactory factory = (EntityManagerFactory)this.entityManagerFactory.get();
            if (factory != null && factory.isOpen()) {
                try {
                    factory.close();
                }
                catch (IllegalStateException illegalStateException) {}
            }
            return false;
        }
    }
}

