/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.boot.tests.internal;

import java.io.File;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.gyrex.boot.internal.app.ServerApplication;
import org.eclipse.gyrex.boot.tests.internal.Activator;
import org.eclipse.gyrex.server.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerTestApplication
extends ServerApplication
implements IApplication {
    private static final Logger LOG = LoggerFactory.getLogger(ServerTestApplication.class);

    private boolean looksLikeTychoSurefireEnvironment(String[] applicationArguments) {
        String[] stringArray = applicationArguments;
        int n = applicationArguments.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (StringUtils.equalsIgnoreCase((String)"-testproperties", (String)arg)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void onApplicationStarted(final Map arguments) {
        Job testRunner = new Job("PDE JUnit Test Runner"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (Boolean.getBoolean("gyrex.preferences.instancebased")) {
                        LOG.warn("Overriding system propert 'gyrex.preferences.instancebased' in order to force ZooKeeper based cloud preferences!");
                        System.setProperty("gyrex.preferences.instancebased", Boolean.FALSE.toString());
                    }
                    long timeout = Long.getLong("gyrex.servertestapp.timeout", 60000L);
                    LOG.info("Waiting {}ms for node to become online...", (Object)timeout);
                    if (!Activator.cloudOnlineWatch.await(timeout, TimeUnit.MILLISECONDS)) {
                        LOG.error("Timeout waiting for ZooKeeper connection.");
                        ServerApplication.shutdown((Throwable)new Exception("Timeout while waiting for node to establish connection with cloud. Unable to initialize cloud environment. Test execution aborted!"));
                        return Status.CANCEL_STATUS;
                    }
                    LOG.info("Executing tests...");
                    ServerTestApplication.this.runTests(ServerTestApplication.getApplicationArguments((Map)arguments));
                    LOG.info("Finished executing tests.");
                    ServerApplication.shutdown(null);
                }
                catch (Exception e) {
                    LOG.error("Failed executing tests. Signaling shutdown!", (Throwable)e);
                    ServerApplication.shutdown((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        testRunner.schedule();
    }

    protected void onBeforeStart(Map arguments) throws Exception {
        File stateArea;
        File zooKeeperDir = Platform.getInstanceLocation().append("zookeeper").toFile();
        if (zooKeeperDir.isDirectory()) {
            FileUtils.deleteDirectory((File)zooKeeperDir);
        }
        if ((stateArea = Platform.getInstanceLocation().append(".metadata/.plugins").toFile()).isDirectory()) {
            FileUtils.deleteDirectory((File)stateArea);
        }
    }

    void runTests(String[] args) {
        if (this.looksLikeTychoSurefireEnvironment(args)) {
            LOG.info("Running in Tycho OSGi Surefire environment.");
            try {
                Class osgiSurefireBooterClass = Activator.getInstance().getBundle().loadClass("org.eclipse.tycho.surefire.osgibooter.OsgiSurefireBooter");
                osgiSurefireBooterClass.getMethod("run", String[].class).invoke(null, new Object[]{args});
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to execute tests using Tycho OSGi Surefire booter. Please verify bundle 'org.eclipse.tycho.surefire.osgibooter' is available!", e);
            }
        }
        LOG.info("Running in PDE JUnit Plug-in Test environment.");
        try {
            Class pdeJunitRunnerClass = Activator.getInstance().getBundle().loadClass("org.eclipse.pde.internal.junit.runtime.RemotePluginTestRunner");
            pdeJunitRunnerClass.getMethod("main", String[].class).invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to execute tests using PDE JUnit Plug-in Test runner. Please verify bundle 'org.eclipse.pde.junit.runtime' is available!", e);
        }
    }
}

