/*******************************************************************************
 * Copyright (c) 2008, 2010 Gunnar Wagenknecht and others.
 * All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Contributors:
 *     Gunnar Wagenknecht - initial API and implementation
 *******************************************************************************/
package org.eclipse.gyrex.model.common.contracts;

/**
 * A model object which knows about the last time it was modified.
 */
public interface IModificationAware {

	/**
	 * Returns the milliseconds from the Java epoch of
	 * <code>1970-01-01T00:00:00Z</code> when the object was last modified in
	 * the underlying data store.
	 * <p>
	 * Typically, the value is not set externally but computed and stored by the
	 * underlying model implementation.
	 * </p>
	 * 
	 * @return the milliseconds from the Java epoch of
	 *         <code>1970-01-01T00:00:00Z</code> when the object was last
	 *         modified, or <code>-1</code> if the object was never modified
	 */
	long getLastModified();

}
