/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.pages.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.gyrex.admin.ui.internal.AdminUiActivator;
import org.eclipse.gyrex.admin.ui.internal.pages.registry.CategoryContribution;
import org.eclipse.gyrex.admin.ui.internal.pages.registry.PageContribution;
import org.eclipse.gyrex.common.lifecycle.IShutdownParticipant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminPageRegistry
extends EventManager
implements IExtensionChangeHandler {
    private static final String ELEMENT_PAGE = "page";
    private static final String ELEMENT_CATEGORY = "category";
    private static final String NO_CATEGORY = "(unknown)";
    private static final String EP_PAGES = "pages";
    private static final Logger LOG = LoggerFactory.getLogger(AdminPageRegistry.class);
    private static final AdminPageRegistry instance = new AdminPageRegistry();
    private final ConcurrentMap<String, PageContribution> pagesById = new ConcurrentHashMap<String, PageContribution>();
    private final ConcurrentMap<String, CategoryContribution> categoriesById = new ConcurrentHashMap<String, CategoryContribution>(4);
    private volatile Map<String, Set<PageContribution>> pagesByCategoryId;

    public static AdminPageRegistry getInstance() {
        return instance;
    }

    private AdminPageRegistry() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        if (registry == null) {
            throw new IllegalStateException("Extension registry is not available!");
        }
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.gyrex.admin.ui", EP_PAGES);
        if (extensionPoint == null) {
            throw new IllegalStateException("Admin pages extension point not found!");
        }
        ExtensionTracker tracker = new ExtensionTracker(registry);
        tracker.registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)extensionPoint));
        AdminUiActivator.getInstance().addShutdownParticipant(new IShutdownParticipant((IExtensionTracker)tracker){
            private final /* synthetic */ IExtensionTracker val$tracker;
            {
                this.val$tracker = iExtensionTracker;
            }

            public void shutdown() throws Exception {
                this.val$tracker.close();
            }
        });
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            this.addExtension((IExtensionTracker)tracker, extensions[i]);
            ++i;
        }
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            CategoryContribution category;
            String id;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (StringUtils.equals((String)ELEMENT_PAGE, (String)element.getName())) {
                PageContribution page = new PageContribution(element);
                id = page.getId();
                if (this.pagesById.putIfAbsent(id, page) == null) {
                    this.rebuildCategories();
                } else {
                    LOG.warn("Ignoring duplicate page {} contributed by {}", (Object)id, (Object)extension.getContributor().getName());
                }
            } else if (StringUtils.equals((String)ELEMENT_CATEGORY, (String)element.getName()) && this.categoriesById.putIfAbsent(id = (category = new CategoryContribution(element)).getId(), category) != null) {
                LOG.warn("Ignoring duplicate category {} contributed by {}", (Object)id, (Object)extension.getContributor().getName());
            }
            ++n2;
        }
    }

    public List<CategoryContribution> getCategories() {
        if (this.categoriesById.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<CategoryContribution>(this.categoriesById.values());
    }

    public PageContribution getPage(String id) {
        return (PageContribution)this.pagesById.get(id);
    }

    public List<PageContribution> getPages(CategoryContribution category) {
        Map<String, Set<PageContribution>> mappings = this.pagesByCategoryId;
        if (mappings == null || mappings.isEmpty()) {
            return Collections.emptyList();
        }
        Set<PageContribution> children = mappings.get(category.getId());
        if (children == null || children.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<PageContribution>(children);
    }

    public CategoryContribution getParent(PageContribution page) {
        if (page.getCategoryId() == null) {
            return null;
        }
        return (CategoryContribution)this.categoriesById.get(page.getCategoryId());
    }

    public boolean hasPages(CategoryContribution category) {
        Map<String, Set<PageContribution>> mappings = this.pagesByCategoryId;
        if (mappings == null) {
            return false;
        }
        String pageId = category != null ? category.getId() : NO_CATEGORY;
        Set<PageContribution> children = mappings.get(pageId);
        return children != null && !children.isEmpty();
    }

    private void rebuildCategories() {
        HashMap<String, Set<PageContribution>> mappings = new HashMap<String, Set<PageContribution>>();
        Collection values = this.pagesById.values();
        for (PageContribution page : values) {
            String categoryId;
            String string = categoryId = page.getCategoryId() != null ? page.getCategoryId() : NO_CATEGORY;
            if (!mappings.containsKey(categoryId)) {
                mappings.put(categoryId, new HashSet(1));
            }
            ((Set)mappings.get(categoryId)).add(page);
        }
        this.pagesByCategoryId = mappings;
    }

    public void removeExtension(IExtension extension, Object[] objects) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String id;
            PageContribution page;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (StringUtils.equals((String)ELEMENT_PAGE, (String)element.getName()) && (page = (PageContribution)this.pagesById.remove(id = element.getAttribute("id"))) != null) {
                this.rebuildCategories();
            }
            ++n2;
        }
    }
}

