/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jetty.internal;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.eclipse.gyrex.http.jetty.admin.ChannelDescriptor;
import org.eclipse.gyrex.http.jetty.admin.ICertificate;
import org.eclipse.gyrex.http.jetty.admin.IJettyManager;
import org.eclipse.gyrex.http.jetty.internal.HttpJettyActivator;
import org.eclipse.gyrex.http.jetty.internal.JettyDebug;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;

public class JettyConsoleCommands
implements CommandProvider {
    static final Map<String, Command> commands = new TreeMap<String, Command>();

    static {
        commands.put("ls", new Command(" connectors|certificates [filterString] \t - list all connectors"){

            @Override
            public void execute(IJettyManager jettyManager, CommandInterpreter ci) throws Exception {
                String what = ci.nextArgument();
                if (what == null) {
                    this.printInvalidArgs(ci);
                    return;
                }
                String filterString = ci.nextArgument();
                if (StringUtils.startsWithIgnoreCase((String)"connectors", (String)what)) {
                    Collection<ChannelDescriptor> channels = jettyManager.getChannels();
                    for (ChannelDescriptor descriptor : channels) {
                        if (filterString != null && !StringUtils.contains((String)descriptor.getId(), (String)filterString)) continue;
                        ci.println((Object)String.format("%s [%s]", descriptor.getId(), descriptor.toString()));
                    }
                } else if (StringUtils.startsWithIgnoreCase((String)"certificates", (String)what)) {
                    Collection<ICertificate> certificates = jettyManager.getCertificates();
                    for (ICertificate certificate : certificates) {
                        if (filterString != null && !StringUtils.contains((String)certificate.getId(), (String)filterString)) continue;
                        ci.println((Object)String.format("%s [%s]", certificate.getId(), certificate.getInfo()));
                    }
                } else {
                    this.printInvalidArgs(ci);
                    ci.println((Object)"Don't know what to list. Connectors? Certificates?");
                    return;
                }
            }
        });
        commands.put("addConnector", new Command("<connectorId> <port> [<secure> <certificateId>]\t - adds a connector"){

            @Override
            public void execute(IJettyManager jettyManager, CommandInterpreter ci) throws Exception {
                String channelId = ci.nextArgument();
                if (channelId == null) {
                    this.printInvalidArgs(ci);
                    return;
                }
                ChannelDescriptor channelDescriptor = jettyManager.getChannel(channelId);
                if (channelDescriptor == null) {
                    channelDescriptor = new ChannelDescriptor();
                }
                channelDescriptor.setId(channelId);
                channelDescriptor.setPort(NumberUtils.toInt((String)ci.nextArgument()));
                channelDescriptor.setSecure(BooleanUtils.toBoolean((String)ci.nextArgument()));
                if (channelDescriptor.isSecure()) {
                    String certificateId = ci.nextArgument();
                    if (certificateId == null) {
                        ci.println((Object)"secure connectors require a certificate id");
                        return;
                    }
                    channelDescriptor.setCertificateId(certificateId);
                }
                jettyManager.saveChannel(channelDescriptor);
                ci.println((Object)("Connector " + channelId + " has been added!"));
            }
        });
        commands.put("removeConnector", new Command("<connectorId>\t - removes a connector"){

            @Override
            public void execute(IJettyManager jettyManager, CommandInterpreter ci) throws Exception {
                String channelId = ci.nextArgument();
                if (channelId == null) {
                    this.printInvalidArgs(ci);
                    return;
                }
                jettyManager.removeChannel(channelId);
                ci.println((Object)("Connector " + channelId + " has been removed!"));
            }
        });
        commands.put("importCertificate", new ImportCertificateCommand("<certificateId> <keystorePath> <keystoreType> [<keystorePassword> [<keyPassword>]]\t - imports a certificate"));
        commands.put("removeCertificate", new Command("<certificateId>\t - removes a certificate"){

            @Override
            public void execute(IJettyManager jettyManager, CommandInterpreter ci) throws Exception {
                String certificateId = ci.nextArgument();
                if (certificateId == null) {
                    this.printInvalidArgs(ci);
                    return;
                }
                jettyManager.removeCertificate(certificateId);
            }
        });
    }

    static void _zkHelp(CommandInterpreter ci) {
        ci.println((Object)"jetty <cmd> [args]");
        for (String cmd : commands.keySet()) {
            ci.println((Object)("\t" + cmd + " " + commands.get(cmd).getHelp()));
        }
    }

    public void _jetty(CommandInterpreter ci) throws Exception {
        String command = ci.nextArgument();
        if (command == null) {
            JettyConsoleCommands._zkHelp(ci);
            return;
        }
        Command cmd = commands.get(command);
        if (cmd == null) {
            ci.println((Object)("ERROR: unknown Jetty command " + command));
            JettyConsoleCommands._zkHelp(ci);
            return;
        }
        IJettyManager manager = null;
        try {
            manager = HttpJettyActivator.getInstance().getJettyManager();
        }
        catch (IllegalStateException illegalStateException) {
            ci.println((Object)"Jetty manager not available!");
            return;
        }
        try {
            cmd.execute(manager, ci);
        }
        catch (Exception e) {
            if (JettyDebug.debug) {
                ci.printStackTrace((Throwable)e);
            }
            ci.println((Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    public String getHelp() {
        StrBuilder help = new StrBuilder(512);
        help.appendln("---Jetty Commands---");
        help.appendln("\tjetty <cmd> [args]");
        for (String cmd : commands.keySet()) {
            help.appendln("\t\t" + cmd + " " + commands.get(cmd).getHelp());
        }
        return help.toString();
    }

    static abstract class Command {
        private final String help;

        public Command(String help) {
            this.help = help;
        }

        public abstract void execute(IJettyManager var1, CommandInterpreter var2) throws Exception;

        public String getHelp() {
            return this.help;
        }

        protected void printInvalidArgs(CommandInterpreter ci) {
            ci.println((Object)"ERROR: invalid arguments");
            ci.println((Object)("\t" + this.getHelp()));
        }
    }

    static final class ImportCertificateCommand
    extends Command {
        private ImportCertificateCommand(String help) {
            super(help);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void execute(IJettyManager jettyManager, CommandInterpreter ci) throws Exception {
            certificateId = ci.nextArgument();
            if (certificateId == null) {
                this.printInvalidArgs(ci);
                return;
            }
            keystorePath = ci.nextArgument();
            if (keystorePath == null) {
                this.printInvalidArgs(ci);
                ci.println((Object)"Missing keystorePath");
                return;
            }
            keystoreType = ci.nextArgument();
            if (keystoreType == null) {
                this.printInvalidArgs(ci);
                ci.println((Object)"Missing keystoreType");
                return;
            }
            if (!keystoreType.equalsIgnoreCase("pkcs12") && !keystoreType.equalsIgnoreCase("jks")) {
                this.printInvalidArgs(ci);
                ci.println((Object)("Unsupported keystoreType: " + keystoreType));
                ci.println((Object)"Supported keystore types are: PKCS12, JKS");
                return;
            }
            keystorePassword = ci.nextArgument();
            keyPassword = ci.nextArgument();
            keystoreInputStream = null;
            try {
                tempKs = KeyStore.getInstance(keystoreType);
                keystoreInputStream = new BufferedInputStream(FileUtils.openInputStream((File)new File(keystorePath)));
                tempKs.load(keystoreInputStream, keystorePassword != null ? keystorePassword.toCharArray() : null);
                ks = KeyStore.getInstance("JKS");
                ks.load(null);
                generatedKeystorePassword = UUID.randomUUID().toString().toCharArray();
                generatedKeyPassword = UUID.randomUUID().toString().toCharArray();
                aliases = tempKs.aliases();
                if (true) ** GOTO lbl56
            }
            catch (Throwable var21_21) {
                IOUtils.closeQuietly(keystoreInputStream);
                throw var21_21;
            }
lbl36:
            // 1 sources

            while (true) {
                IOUtils.closeQuietly((InputStream)keystoreInputStream);
                return;
            }
            {
                block13: {
                    while (true) {
                        chain = new Certificate[]{certificate};
                        while (true) {
                            var20_18 = chain;
                            var19_19 = chain.length;
                            var18_20 = 0;
                            while (true) {
                                if (var18_20 >= var19_19) {
                                    ks.setKeyEntry("jetty", key, generatedKeyPassword, chain);
                                    break block13;
                                }
                                certificate = var20_18[var18_20];
                                ci.println((Object)"Found certificate:");
                                ci.println((Object)certificate);
                                ++var18_20;
                            }
                            break;
                        }
                        break;
                    }
                    do {
                        ci.println((Object)("No key available for entry: " + alias));
lbl56:
                        // 2 sources

                        if (!aliases.hasMoreElements()) break block13;
                        alias = aliases.nextElement();
                        ci.println((Object)("Processing entry: " + alias));
                    } while (!tempKs.isKeyEntry(alias));
                    ci.println((Object)("Loading key for entry: " + alias));
                    key = tempKs.getKey(alias, keyPassword != null ? keyPassword.toCharArray() : (char[])(keystorePassword != null ? keystorePassword.toCharArray() : null));
                    ci.println((Object)("Loading certificate chain for entry: " + alias));
                    if ((chain = tempKs.getCertificateChain(alias)) != null) ** continue;
                    if ((certificate = tempKs.getCertificate(alias)) != null) ** continue;
                    ci.println((Object)("CertificateDefinition chain missing for key '" + alias + "'!"));
                    ci.println((Object)"Please import the complete certificate change into the keystore");
                    ** continue;
                }
                out = new ByteArrayOutputStream();
                ks.store(out, generatedKeystorePassword);
                jettyManager.addCertificate(certificateId, out.toByteArray(), generatedKeystorePassword, generatedKeyPassword);
                ci.println((Object)("Imported certificate " + certificateId + "!"));
            }
            IOUtils.closeQuietly((InputStream)keystoreInputStream);
        }
    }
}

