/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.http.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.http.internal.HttpActivator;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationManager;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationProviderRegistration;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationRegistration;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.osgi.service.prefs.BackingStoreException;

public final class ApplicationBrowserContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    Viewer viewer;

    private void attach(Object input) {
    }

    private void detach(Object input) {
    }

    public void dispose() {
        if (this.viewer != null) {
            this.detach(this.viewer.getInput());
            this.viewer = null;
        }
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof GroupNode) {
            return ((GroupNode)parentElement).getChildren().toArray();
        }
        return EMPTY_ARRAY;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof ApplicationManager) {
            ApplicationManager appManager = (ApplicationManager)inputElement;
            HashMap<Object, GroupNode> treeItems = new HashMap<Object, GroupNode>();
            try {
                TreeSet registeredApplications = new TreeSet(appManager.getRegisteredApplications());
                for (String appId : registeredApplications) {
                    ApplicationRegistration applicationRegistration = appManager.getApplicationRegistration(appId);
                    IRuntimeContext groupObject = applicationRegistration.getContext();
                    GroupNode treeGroup = (GroupNode)treeItems.get(groupObject);
                    if (treeGroup == null) {
                        treeGroup = new GroupNode(groupObject);
                        treeItems.put(treeGroup.getValue(), treeGroup);
                    }
                    IEclipsePreferences urlsNode = ApplicationManager.getUrlsNode();
                    TreeSet<String> mounts = new TreeSet<String>();
                    try {
                        String[] urls;
                        String[] stringArray = urls = urlsNode.keys();
                        int n = urls.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String url = stringArray[n2];
                            if (appId.equals(urlsNode.get(url, ""))) {
                                mounts.add(url);
                            }
                            ++n2;
                        }
                    }
                    catch (BackingStoreException e) {
                        mounts.add(e.getMessage());
                    }
                    ApplicationProviderRegistration applicationProviderRegistration = (ApplicationProviderRegistration)HttpActivator.getInstance().getProviderRegistry().getRegisteredProviders().get(applicationRegistration.getProviderId());
                    ApplicationItem item = new ApplicationItem(applicationRegistration, applicationProviderRegistration, appManager.isActive(appId), mounts);
                    treeGroup.addChild(item);
                }
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
            return treeItems.values().toArray();
        }
        return EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        if (element instanceof ApplicationItem) {
            return ((ApplicationItem)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof GroupNode;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.viewer != null && this.viewer != viewer) {
            throw new IllegalStateException("please use separate provider instance for different viewers");
        }
        this.viewer = viewer;
        this.detach(oldInput);
        this.attach(newInput);
    }

    public static class ApplicationItem {
        private final Set<String> mounts;
        private final ApplicationRegistration applicationRegistration;
        private final ApplicationProviderRegistration applicationProviderRegistration;
        private GroupNode parent;
        private final boolean active;

        public ApplicationItem(ApplicationRegistration applicationRegistration, ApplicationProviderRegistration applicationProviderRegistration, boolean active, Set<String> mounts) {
            this.applicationRegistration = applicationRegistration;
            this.applicationProviderRegistration = applicationProviderRegistration;
            this.active = active;
            this.mounts = mounts;
        }

        public String getApplicationId() {
            return this.applicationRegistration.getApplicationId();
        }

        public ApplicationProviderRegistration getApplicationProviderRegistration() {
            return this.applicationProviderRegistration;
        }

        public ApplicationRegistration getApplicationRegistration() {
            return this.applicationRegistration;
        }

        public String getContextPath() {
            return this.applicationRegistration.getContext().getContextPath().toString();
        }

        public Set<String> getMounts() {
            return this.mounts;
        }

        public GroupNode getParent() {
            return this.parent;
        }

        public String getProviderId() {
            return this.applicationRegistration.getProviderId();
        }

        public String getProviderLabel() {
            String providerInfo = this.applicationProviderRegistration.getProviderInfo();
            if (StringUtils.isNotBlank((String)providerInfo)) {
                return providerInfo;
            }
            return this.applicationRegistration.getProviderId();
        }

        public boolean isActive() {
            return this.active;
        }

        public void setParent(GroupNode parent) {
            this.parent = parent;
        }
    }

    public static class GroupNode {
        private final Object value;
        private final List<ApplicationItem> children = new ArrayList<ApplicationItem>();

        public GroupNode(Object value) {
            this.value = value;
        }

        public void addChild(ApplicationItem item) {
            this.children.add(item);
        }

        public List<ApplicationItem> getChildren() {
            return this.children;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

