/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.preferences.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.gyrex.preferences.internal.PreferencesActivator;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class InstanceBasedPreferences
implements IEclipsePreferences {
    private static final IEclipsePreferences[] EMPTY_NODE_ARRAY = new IEclipsePreferences[0];
    private static final String PATH_SEPARATOR = String.valueOf('/');
    private static final String EMPTY_STRING = "";
    private final IEclipsePreferences instanceNode;
    private String cachedPath;
    private final String name;
    private final IEclipsePreferences parent;
    private boolean removed;

    public InstanceBasedPreferences(IEclipsePreferences parent, String name) {
        this(parent, name, false);
    }

    InstanceBasedPreferences(IEclipsePreferences parent, String name, boolean removed) {
        this.parent = parent;
        this.name = name;
        this.removed = removed;
        if (parent != null && name != null) {
            if (parent instanceof InstanceBasedPreferences) {
                this.instanceNode = (IEclipsePreferences)((InstanceBasedPreferences)parent).instanceNode.node(name);
            } else {
                if (!parent.absolutePath().equals(PATH_SEPARATOR) || !name.equals("cloud")) {
                    throw new IllegalArgumentException(NLS.bind((String)"name {0} and parent {1} not allowed at this point", (Object)name, (Object)parent));
                }
                this.instanceNode = (IEclipsePreferences)PreferencesActivator.getInstance().getPreferencesService().getRootNode().node("instance").node("org.eclipse.gyrex.preferences").node(name);
            }
        } else {
            this.instanceNode = null;
        }
    }

    public String absolutePath() {
        if (this.cachedPath == null) {
            String parentPath;
            this.cachedPath = this.parent == null ? PATH_SEPARATOR : ((parentPath = this.parent.absolutePath()).length() == 1 ? String.valueOf(parentPath) + this.name() : String.valueOf(parentPath) + PATH_SEPARATOR + this.name());
        }
        return this.cachedPath;
    }

    public void accept(IPreferenceNodeVisitor visitor) throws BackingStoreException {
        this.checkRemoved();
        if (!visitor.visit((IEclipsePreferences)this)) {
            return;
        }
        IEclipsePreferences[] toVisit = this.getChildren(true);
        int i = 0;
        while (i < toVisit.length) {
            toVisit[i].accept(visitor);
            ++i;
        }
    }

    public void addNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
        this.checkRemoved();
        this.instanceNode.addNodeChangeListener((IEclipsePreferences.INodeChangeListener)new NodeChangeListenerWrapper(listener));
    }

    public void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        this.checkRemoved();
        this.instanceNode.addPreferenceChangeListener(listener);
    }

    private IEclipsePreferences calculateRoot() {
        InstanceBasedPreferences result = this;
        while (result.parent() != null) {
            result = (IEclipsePreferences)result.parent();
        }
        return result;
    }

    private void checkRemoved() throws IllegalStateException {
        if (this.removed) {
            throw new IllegalStateException(String.format("Node '%s' has been removed.", this.name));
        }
    }

    public String[] childrenNames() throws BackingStoreException {
        this.checkRemoved();
        return this.instanceNode.childrenNames();
    }

    public void clear() throws BackingStoreException {
        this.checkRemoved();
        this.instanceNode.clear();
    }

    public void flush() throws BackingStoreException {
        this.checkRemoved();
        this.instanceNode.flush();
    }

    public String get(String key, String def) {
        this.checkRemoved();
        return this.instanceNode.get(key, def);
    }

    public boolean getBoolean(String key, boolean def) {
        this.checkRemoved();
        return this.instanceNode.getBoolean(key, def);
    }

    public byte[] getByteArray(String key, byte[] def) {
        this.checkRemoved();
        return this.instanceNode.getByteArray(key, def);
    }

    protected IEclipsePreferences[] getChildren(boolean create) throws BackingStoreException {
        ArrayList<InstanceBasedPreferences> result = new ArrayList<InstanceBasedPreferences>();
        String[] names = this.childrenNames();
        int i = 0;
        while (i < names.length) {
            if (create || this.instanceNode.nodeExists(this.name)) {
                result.add(new InstanceBasedPreferences(this, this.name, false));
            }
            ++i;
        }
        return result.toArray(EMPTY_NODE_ARRAY);
    }

    public double getDouble(String key, double def) {
        this.checkRemoved();
        return this.instanceNode.getDouble(key, def);
    }

    public float getFloat(String key, float def) {
        this.checkRemoved();
        return this.instanceNode.getFloat(key, def);
    }

    public int getInt(String key, int def) {
        this.checkRemoved();
        return this.instanceNode.getInt(key, def);
    }

    public long getLong(String key, long def) {
        this.checkRemoved();
        return this.instanceNode.getLong(key, def);
    }

    public String[] keys() throws BackingStoreException {
        this.checkRemoved();
        return this.instanceNode.keys();
    }

    public String name() {
        return this.name;
    }

    public Preferences node(String path) {
        this.checkRemoved();
        if (path.length() == 0) {
            return this;
        }
        if (path.charAt(0) == '/') {
            return this.calculateRoot().node(path.substring(1));
        }
        int index = path.indexOf(47);
        String key = index == -1 ? path : path.substring(0, index);
        InstanceBasedPreferences child = new InstanceBasedPreferences(this, key, false);
        return child.node(index == -1 ? EMPTY_STRING : path.substring(index + 1));
    }

    public boolean nodeExists(String pathName) throws BackingStoreException {
        return this.instanceNode.nodeExists(pathName);
    }

    public Preferences parent() {
        this.checkRemoved();
        return this.parent;
    }

    public void put(String key, String value) {
        this.checkRemoved();
        this.instanceNode.put(key, value);
    }

    public void putBoolean(String key, boolean value) {
        this.checkRemoved();
        this.instanceNode.putBoolean(key, value);
    }

    public void putByteArray(String key, byte[] value) {
        this.checkRemoved();
        this.instanceNode.putByteArray(key, value);
    }

    public void putDouble(String key, double value) {
        this.checkRemoved();
        this.instanceNode.putDouble(key, value);
    }

    public void putFloat(String key, float value) {
        this.checkRemoved();
        this.instanceNode.putFloat(key, value);
    }

    public void putInt(String key, int value) {
        this.checkRemoved();
        this.instanceNode.putInt(key, value);
    }

    public void putLong(String key, long value) {
        this.checkRemoved();
        this.instanceNode.putLong(key, value);
    }

    public void remove(String key) {
        this.checkRemoved();
        this.instanceNode.remove(key);
    }

    public void removeNode() throws BackingStoreException {
        this.removed = true;
        this.instanceNode.removeNode();
    }

    public void removeNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
        this.checkRemoved();
        this.instanceNode.removeNodeChangeListener((IEclipsePreferences.INodeChangeListener)new NodeChangeListenerWrapper(listener));
    }

    public void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        this.checkRemoved();
        this.instanceNode.removePreferenceChangeListener(listener);
    }

    public void sync() throws BackingStoreException {
        this.checkRemoved();
        this.instanceNode.sync();
    }

    public String toString() {
        return this.absolutePath();
    }

    private final class NodeChangeListenerWrapper
    implements IEclipsePreferences.INodeChangeListener {
        private final IEclipsePreferences.INodeChangeListener listener;

        private NodeChangeListenerWrapper(IEclipsePreferences.INodeChangeListener listener) {
            this.listener = listener;
        }

        public void added(IEclipsePreferences.NodeChangeEvent event) {
            if (event.getParent().equals(InstanceBasedPreferences.this.instanceNode)) {
                InstanceBasedPreferences child = new InstanceBasedPreferences(InstanceBasedPreferences.this, event.getChild().name(), false);
                this.listener.added(new IEclipsePreferences.NodeChangeEvent((Preferences)InstanceBasedPreferences.this, (Preferences)child));
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeChangeListenerWrapper other = (NodeChangeListenerWrapper)obj;
            return !(this.listener == null ? other.listener != null : !this.listener.equals(other.listener));
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.listener == null ? 0 : this.listener.hashCode());
            return result;
        }

        public void removed(IEclipsePreferences.NodeChangeEvent event) {
            if (event.getParent().equals(InstanceBasedPreferences.this.instanceNode)) {
                InstanceBasedPreferences child = new InstanceBasedPreferences(InstanceBasedPreferences.this, event.getChild().name(), true);
                this.listener.removed(new IEclipsePreferences.NodeChangeEvent((Preferences)InstanceBasedPreferences.this, (Preferences)child));
            }
        }
    }
}

