/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.http.internal;

import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.admin.ui.adapter.AdapterUtil;
import org.eclipse.gyrex.admin.ui.adapter.LabelAdapter;
import org.eclipse.gyrex.admin.ui.http.internal.ApplicationBrowserContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public final class ApplicationBrowserComparator
extends ViewerComparator {
    private static final long serialVersionUID = 1L;
    private SortIndex index = SortIndex.ID;
    private boolean reverse;

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (e1 instanceof ApplicationBrowserContentProvider.ApplicationItem && e2 instanceof ApplicationBrowserContentProvider.ApplicationItem) {
            return this.compareAppRegs((ApplicationBrowserContentProvider.ApplicationItem)e1, (ApplicationBrowserContentProvider.ApplicationItem)e2);
        }
        if (e1 instanceof ApplicationBrowserContentProvider.GroupNode && e2 instanceof ApplicationBrowserContentProvider.GroupNode) {
            return this.compareGroupingItems((ApplicationBrowserContentProvider.GroupNode)e1, (ApplicationBrowserContentProvider.GroupNode)e2);
        }
        return super.compare(viewer, e1, e2);
    }

    private int compareAppRegs(ApplicationBrowserContentProvider.ApplicationItem n1, ApplicationBrowserContentProvider.ApplicationItem n2) {
        String t1 = StringUtils.trimToEmpty((String)this.getText(n1));
        String t2 = StringUtils.trimToEmpty((String)this.getText(n2));
        if (this.isReverse()) {
            return this.getComparator().compare(t2, t1);
        }
        return this.getComparator().compare(t1, t2);
    }

    private int compareGroupingItems(ApplicationBrowserContentProvider.GroupNode e1, ApplicationBrowserContentProvider.GroupNode e2) {
        if (SortIndex.ID.equals((Object)this.getIndex())) {
            String v1 = this.getLabel(e1.getValue());
            String v2 = this.getLabel(e2.getValue());
            if (this.isReverse()) {
                return this.getComparator().compare(v2, v1);
            }
            return this.getComparator().compare(v1, v2);
        }
        return 0;
    }

    public SortIndex getIndex() {
        return this.index != null ? this.index : SortIndex.ID;
    }

    private String getLabel(Object o) {
        LabelAdapter adapter = (LabelAdapter)AdapterUtil.getAdapter((Object)0, LabelAdapter.class);
        if (adapter != null) {
            return adapter.getLabel(o);
        }
        return String.valueOf(o);
    }

    private String getText(ApplicationBrowserContentProvider.ApplicationItem appReg) {
        switch (this.getIndex()) {
            case ID: {
                return appReg.getApplicationId();
            }
            case PROVIDER_ID: {
                return appReg.getProviderLabel();
            }
            case CONTEXT: {
                return appReg.getContextPath();
            }
            case MOUNTS: {
                return StringUtils.join(appReg.getMounts(), (String)", ");
            }
        }
        return appReg.getContextPath();
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setIndex(SortIndex index) {
        this.index = index;
        this.reverse = false;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public static enum SortIndex {
        ID,
        PROVIDER_ID,
        CONTEXT,
        STATUS,
        MOUNTS;

    }
}

