/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.http.internal;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.admin.ui.internal.widgets.NonBlockingStatusDialog;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.Separator;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class EditPropertyDialog
extends NonBlockingStatusDialog {
    private final StringDialogField keyField = new StringDialogField();
    private final StringDialogField valueField = new StringDialogField();
    private final String key;
    private final String value;

    public EditPropertyDialog(Shell parent, String key, String value) {
        super(parent);
        this.key = key;
        this.value = value;
        this.setTitle(key == null ? "New Property" : "Edit Property");
        this.setShellStyle(67696);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = (GridData)composite.getLayoutData();
        gd.minimumHeight = this.convertVerticalDLUsToPixels(80);
        gd.minimumWidth = this.convertHorizontalDLUsToPixels(400);
        this.keyField.setLabelText("Name");
        this.valueField.setLabelText("Value");
        IDialogFieldListener validateListener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                EditPropertyDialog.this.validate();
            }
        };
        this.keyField.setDialogFieldListener(validateListener);
        this.valueField.setDialogFieldListener(validateListener);
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{new Separator(), this.keyField, this.valueField}, (boolean)false);
        LayoutUtil.setHorizontalGrabbing((Control)this.keyField.getTextControl(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.valueField.getTextControl(null));
        if (this.key != null) {
            this.keyField.setText(this.key);
            this.keyField.setEnabled(false);
        } else {
            this.keyField.setFocus();
        }
        if (this.value != null) {
            this.valueField.setText(this.value);
            this.valueField.getTextControl(null).selectAll();
            this.valueField.getTextControl(null).setFocus();
        }
        return composite;
    }

    public String getKey() {
        return this.keyField.getText();
    }

    public String getValue() {
        return this.valueField.getText();
    }

    protected void okPressed() {
        this.validate();
        if (!this.getStatus().isOK()) {
            return;
        }
        super.okPressed();
    }

    void setError(String message) {
        this.updateStatus((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.http", message));
        this.getShell().pack(true);
    }

    void setInfo(String message) {
        this.updateStatus((IStatus)new Status(1, "org.eclipse.gyrex.admin.ui.http", message));
    }

    void setWarning(String message) {
        this.updateStatus((IStatus)new Status(2, "org.eclipse.gyrex.admin.ui.http", message));
    }

    void validate() {
        String key;
        if (this.key == null && StringUtils.isBlank((String)(key = this.getKey()))) {
            this.setInfo("Please enter a property name.");
            return;
        }
        this.updateStatus(Status.OK_STATUS);
    }
}

