/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.monitor.jmx;

import org.eclipse.jetty.monitor.jmx.EventNotifier;
import org.eclipse.jetty.monitor.jmx.EventState;
import org.eclipse.jetty.monitor.jmx.EventTrigger;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class LoggingNotifier
implements EventNotifier {
    private static final Logger LOG = Log.getLogger(LoggingNotifier.class);
    String _messageFormat;

    public LoggingNotifier(String format) throws IllegalArgumentException {
        if (format == null) {
            throw new IllegalArgumentException("Message format cannot be null");
        }
        this._messageFormat = format;
    }

    @Override
    public void notify(EventTrigger trigger, EventState<?> state, long timestamp) {
        String output = String.format(this._messageFormat, state);
        LOG.info(output, new Object[0]);
    }
}

