/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.boot.internal.ssh;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import org.apache.mina.util.Base64;

public class AuthorizedKeys {
    private static final String PREFIX_KEY_TYPE = "ssh-";
    private static final String PREFIX_KEY_TYPE_DSA = "ssh-dsa ";
    private static final String PREFIX_KEY_TYPE_RSA = "ssh-rsa ";
    private static final String NEWLINE = "\n";
    private final List<PublicKey> keys;

    private static byte[] asBytes(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string.getBytes();
        }
    }

    private static String asString(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(bytes);
        }
    }

    public static void main(String[] args) {
        try {
            List<PublicKey> keys = new AuthorizedKeys(args[0]).getKeys();
            for (PublicKey key : keys) {
                System.out.println(key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AuthorizedKeys(String authorizedKeysFile) throws FileNotFoundException, IOException {
        ArrayList<PublicKey> keys;
        block7: {
            File file = new File(authorizedKeysFile);
            Scanner scanner = new Scanner(file);
            scanner.useDelimiter(NEWLINE);
            int lineNumber = 0;
            keys = new ArrayList<PublicKey>();
            block5: while (true) {
                while (scanner.hasNext()) {
                    ++lineNumber;
                    String line = scanner.next().trim();
                    if (line.length() == 0 || line.charAt(0) == '#') continue;
                    try {
                        keys.add(this.readPublicKey(line));
                        continue block5;
                    }
                    catch (Exception e) {
                        throw new ParseKeyException("Line " + lineNumber + ": " + e.getMessage(), e);
                    }
                }
                break block7;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                scanner.close();
            }
        }
        this.keys = Collections.unmodifiableList(keys);
    }

    public List<PublicKey> getKeys() {
        return this.keys;
    }

    private BigInteger readBigInteger(ByteBuffer buffer) {
        int len = buffer.getInt();
        byte[] bytes = new byte[len];
        buffer.get(bytes);
        BigInteger pubExp = new BigInteger(bytes);
        return pubExp;
    }

    private PublicKey readPublicKey(String line) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        byte[] key;
        KeyType type;
        if (!line.startsWith(PREFIX_KEY_TYPE)) {
            int keyTypeStart = line.indexOf(PREFIX_KEY_TYPE);
            if (keyTypeStart == -1) {
                throw new IOException("missing key type");
            }
            line = line.substring(keyTypeStart);
        }
        if (line.startsWith(PREFIX_KEY_TYPE_DSA)) {
            line = line.substring(PREFIX_KEY_TYPE_DSA.length());
            type = KeyType.DSA;
        } else if (line.startsWith(PREFIX_KEY_TYPE_RSA)) {
            line = line.substring(PREFIX_KEY_TYPE_RSA.length());
            type = KeyType.RSA;
        } else {
            throw new IOException("unsupported key type");
        }
        int keyEndIdx = line.indexOf(32);
        if (keyEndIdx != -1) {
            key = Base64.decodeBase64((byte[])AuthorizedKeys.asBytes(line.substring(0, keyEndIdx)));
            line = line.substring(keyEndIdx + 1);
        } else {
            key = Base64.decodeBase64((byte[])AuthorizedKeys.asBytes(line));
        }
        ByteBuffer buffer = ByteBuffer.wrap(key);
        this.readString(buffer);
        switch (type) {
            case RSA: {
                BigInteger pubExp = this.readBigInteger(buffer);
                BigInteger mod = this.readBigInteger(buffer);
                return KeyFactory.getInstance(KeyType.RSA.name()).generatePublic(new RSAPublicKeySpec(mod, pubExp));
            }
            case DSA: {
                BigInteger p = this.readBigInteger(buffer);
                BigInteger q = this.readBigInteger(buffer);
                BigInteger g = this.readBigInteger(buffer);
                BigInteger y = this.readBigInteger(buffer);
                return KeyFactory.getInstance(KeyType.DSA.name()).generatePublic(new DSAPublicKeySpec(y, p, q, g));
            }
        }
        throw new IOException("not implemented: " + (Object)((Object)type));
    }

    private String readString(ByteBuffer buffer) {
        int len = buffer.getInt();
        byte[] bytes = new byte[len];
        buffer.get(bytes);
        return AuthorizedKeys.asString(bytes);
    }

    public static enum KeyType {
        RSA,
        DSA;

    }

    public static class ParseKeyException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public ParseKeyException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

