/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.commands;

import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gyrex.common.console.Command;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.registry.IRuntimeContextRegistry;
import org.eclipse.gyrex.jobs.internal.JobsActivator;
import org.eclipse.gyrex.jobs.schedules.manager.IScheduleManager;
import org.eclipse.gyrex.jobs.schedules.manager.IScheduleWorkingCopy;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

public class CreateScheduleCmd
extends Command {
    @Option(name="-tz", aliases={"--time-zone"}, usage="an optional timezone the schedule will operate in")
    String tz;
    @Argument(index=0, usage="the path of the context the schedule will operate in", required=true, metaVar="CONTEXTPATH")
    String contextPath;
    @Argument(index=1, usage="the schedule id", required=true, metaVar="SCHEDULEID")
    String scheduleId;

    public CreateScheduleCmd() {
        super("<contextPath> <scheduleId> - creates a schedule");
    }

    protected void doExecute() throws Exception {
        Path parsedContextPath = new Path(this.contextPath);
        IRuntimeContext context = ((IRuntimeContextRegistry)JobsActivator.getInstance().getService(IRuntimeContextRegistry.class)).get((IPath)parsedContextPath);
        if (context == null) {
            this.printf("Context '%s' not defined!", new Object[]{parsedContextPath});
            return;
        }
        IScheduleManager manager = (IScheduleManager)context.get(IScheduleManager.class);
        IScheduleWorkingCopy schedule = manager.createSchedule(this.scheduleId);
        if (StringUtils.isNotBlank((String)this.tz)) {
            schedule.setTimeZone(TimeZone.getTimeZone(this.tz));
        }
        manager.updateSchedule(schedule);
        this.printf("Created schedule %s!", new Object[]{schedule.getId()});
    }
}

