/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.manager;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.time.DateFormatUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.jobs.IJob;
import org.eclipse.gyrex.jobs.JobState;

public class JobImpl
implements IJob {
    private final String storageKey;
    private String id;
    private String typeId;
    private Map<String, String> parameter;
    private long lastQueued;
    private long lastStart;
    private long lastCancelled;
    private long lastSuccessfulFinish;
    private JobState state;
    private long lastResultTimestamp;
    private IStatus lastResult;
    private boolean active;
    private String lastQueuedTrigger;
    private String lastCancelledTrigger;

    public JobImpl(String storageKey) {
        this.storageKey = storageKey;
        this.lastSuccessfulFinish = -1L;
        this.lastStart = -1L;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public long getLastCancelled() {
        return this.lastCancelled;
    }

    @Override
    public String getLastCancelledTrigger() {
        return this.lastCancelledTrigger;
    }

    @Override
    public long getLastQueued() {
        return this.lastQueued;
    }

    @Override
    public String getLastQueuedTrigger() {
        return this.lastQueuedTrigger;
    }

    @Override
    public IStatus getLastResult() {
        return this.lastResult;
    }

    public long getLastResultTimestamp() {
        return this.lastResultTimestamp;
    }

    @Override
    public long getLastStart() {
        return this.lastStart;
    }

    @Override
    public long getLastSuccessfulFinish() {
        return this.lastSuccessfulFinish;
    }

    @Override
    public Map<String, String> getParameter() {
        Map<String, String> map = this.parameter;
        if (map == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public JobState getState() {
        JobState jobState = this.state;
        if (jobState == null) {
            return JobState.NONE;
        }
        return this.state;
    }

    public String getStorageKey() {
        return this.storageKey;
    }

    @Override
    public String getTypeId() {
        return this.typeId;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLastCancelled(long lastCancelled) {
        this.lastCancelled = lastCancelled;
    }

    public void setLastCancelledTrigger(String lastCancelledTrigger) {
        this.lastCancelledTrigger = lastCancelledTrigger;
    }

    public void setLastQueued(long lastQueued) {
        this.lastQueued = lastQueued;
    }

    public void setLastQueuedTrigger(String lastTrigger) {
        this.lastQueuedTrigger = lastTrigger;
    }

    public void setLastResult(long timestamp, int severity, String message) {
        this.lastResultTimestamp = timestamp;
        try {
            this.lastResult = new Status(severity, "org.eclipse.gyrex.jobs", message);
        }
        catch (Exception e) {
            this.lastResult = new Status(8, "org.eclipse.gyrex.jobs", String.format("Error reading result. %s", e.getMessage()));
        }
    }

    public void setLastStart(long lastStart) {
        this.lastStart = lastStart;
    }

    public void setLastSuccessfulFinish(long lastSuccessfullFinish) {
        this.lastSuccessfulFinish = lastSuccessfullFinish;
    }

    public void setParameter(Map<String, String> parameter) {
        this.parameter = parameter;
    }

    public void setStatus(JobState status) {
        this.state = status;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public String toString() {
        IStatus result;
        long start;
        StringBuilder builder = new StringBuilder();
        builder.append("Job [").append(this.id).append(" (type ").append(this.typeId).append(")");
        JobState state = this.getState();
        if (state != JobState.NONE) {
            builder.append(", ").append((Object)state);
        }
        if ((start = this.lastStart) > 0L) {
            builder.append(", last started ").append(DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(start));
        }
        if ((result = this.lastResult) != null) {
            builder.append(", last result ").append(result);
        }
        return builder.append("]").toString();
    }
}

