/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.admin;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.gyrex.cloud.admin.INodeConfigurer;
import org.eclipse.gyrex.cloud.internal.CloudState;
import org.eclipse.gyrex.cloud.internal.NodeInfo;
import org.eclipse.gyrex.cloud.internal.zk.IZooKeeperLayout;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGateApplication;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperNodeInfo;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeConfigurer
implements INodeConfigurer {
    private static final Logger LOG = LoggerFactory.getLogger(NodeConfigurer.class);
    private final String nodeId;

    public NodeConfigurer(String nodeId) {
        this.nodeId = nodeId;
    }

    @Override
    public IStatus configureConnection(String connectString) {
        ZooKeeper zk = null;
        try {
            try {
                if (connectString != null) {
                    String createdPath;
                    String path;
                    final CountDownLatch connected = new CountDownLatch(1);
                    zk = new ZooKeeper(connectString, 5000, new Watcher(){

                        public void process(WatchedEvent event) {
                            if (event.getType() == Watcher.Event.EventType.None && event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                                connected.countDown();
                            }
                        }
                    });
                    connected.await(5000L, TimeUnit.MILLISECONDS);
                    if (zk.getState() != ZooKeeper.States.CONNECTED) {
                        throw new IllegalStateException(String.format("Timeout waiting for a connection to '%s'. Please verify the connect string.", connectString));
                    }
                    if (zk.exists(IZooKeeperLayout.PATH_GYREX_ROOT.toString(), false) == null && !(path = IZooKeeperLayout.PATH_GYREX_ROOT.toString()).equals(createdPath = zk.create(path, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT))) {
                        throw new IllegalStateException(String.format("created path does not match expected path (%s != %s)", path, createdPath));
                    }
                }
                if (new NodeInfo().getNodeId().equals(this.nodeId)) {
                    Preferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.gyrex.cloud").node("zookeeper");
                    if (connectString != null) {
                        preferences.put("clientConnectString", connectString);
                    } else {
                        preferences.remove("clientConnectString");
                    }
                    preferences.flush();
                    CloudState.unregisterNode();
                    ZooKeeperGateApplication.reconnect();
                    CloudState.registerNode();
                }
            }
            catch (Exception e) {
                LOG.debug("Exception connecting to cloud using connect string {}.", (Object)connectString, (Object)e);
                Status status = new Status(4, "org.eclipse.gyrex.cloud", "Unable to connect to ZooKeeper. " + ExceptionUtils.getRootCauseMessage((Throwable)e), (Throwable)e);
                if (zk != null) {
                    try {
                        zk.close();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return status;
            }
        }
        catch (Throwable throwable) {
            if (zk != null) {
                try {
                    zk.close();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            throw throwable;
        }
        if (zk != null) {
            try {
                zk.close();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        return Status.OK_STATUS;
    }

    @Override
    public String getConnectionString() {
        Preferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.gyrex.cloud").node("zookeeper");
        return preferences.get("clientConnectString", null);
    }

    @Override
    public IStatus setLocation(String text) {
        try {
            ZooKeeperNodeInfo info = ZooKeeperNodeInfo.load(this.nodeId, true);
            info.setLocation(text);
            ZooKeeperNodeInfo.save(info, true);
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.gyrex.cloud", "Unable to update node info in ZooKeeper. " + ExceptionUtils.getRootCauseMessage((Throwable)e), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus setName(String text) {
        try {
            ZooKeeperNodeInfo info = ZooKeeperNodeInfo.load(this.nodeId, true);
            info.setName(text);
            ZooKeeperNodeInfo.save(info, true);
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.gyrex.cloud", "Unable to update node info in ZooKeeper. " + ExceptionUtils.getRootCauseMessage((Throwable)e), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus setTags(Set<String> tags) {
        try {
            ZooKeeperNodeInfo info = ZooKeeperNodeInfo.load(this.nodeId, true);
            info.setTags(tags);
            ZooKeeperNodeInfo.save(info, true);
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.gyrex.cloud", "Unable to update node info in ZooKeeper. " + ExceptionUtils.getRootCauseMessage((Throwable)e), (Throwable)e);
        }
        return Status.OK_STATUS;
    }
}

