/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.state;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.cloud.internal.state.ZooKeeperNodeStatePublisher;
import org.eclipse.gyrex.cloud.services.state.INodeState;
import org.eclipse.gyrex.cloud.services.state.query.INodeStateInfo;
import org.eclipse.gyrex.cloud.services.state.query.INodeStateQueryService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class ZooKeeperNodeStateService
extends ServiceTracker<INodeState, INodeState>
implements INodeStateQueryService {
    private final ZooKeeperNodeStatePublisher statePublisher;

    public ZooKeeperNodeStateService(BundleContext context, String myNodeId) {
        super(context, INodeState.class, null);
        this.statePublisher = new ZooKeeperNodeStatePublisher(myNodeId);
    }

    public INodeState addingService(ServiceReference<INodeState> reference) {
        INodeState service = (INodeState)super.getService();
        if (service == null) {
            return service;
        }
        String pid = (String)reference.getProperty("service.pid");
        if (StringUtils.isNotBlank((String)pid)) {
            this.statePublisher.publish(pid, reference);
        }
        return service;
    }

    public void close() {
        try {
            super.close();
        }
        finally {
            this.statePublisher.shutdown();
        }
    }

    @Override
    public List<INodeStateInfo> findByNodeId(String nodeId) {
        return Collections.unmodifiableList(this.statePublisher.findByNodeId(nodeId));
    }

    @Override
    public List<INodeStateInfo> findByServicePid(String servicePid) {
        return Collections.unmodifiableList(this.statePublisher.findByServicePid(servicePid));
    }

    public void modifiedService(ServiceReference<INodeState> reference, INodeState service) {
        String pid = (String)reference.getProperty("service.pid");
        if (StringUtils.isNotBlank((String)pid)) {
            this.statePublisher.publish(pid, reference);
        }
    }

    public void removedService(ServiceReference<INodeState> reference, INodeState service) {
        super.removedService(reference, (Object)service);
        String pid = (String)reference.getProperty("service.pid");
        if (StringUtils.isNotBlank((String)pid)) {
            this.statePublisher.remove(pid);
        }
    }
}

