/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.log.internal;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;

public class WildfireAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final ThreadLocal<HttpServletResponse> responseHolder = new ThreadLocal();
    private static final ThreadLocal<AtomicInteger> sequenceHolder = new ThreadLocal();
    Layout<ILoggingEvent> layout;
    String pattern;

    public static String getType(ILoggingEvent event) {
        switch (event.getLevel().levelInt) {
            case 20000: 
            case 30000: 
            case 40000: {
                return event.getLevel().levelStr;
            }
        }
        return "LOG";
    }

    public static void setResponse(HttpServletResponse resp) {
        responseHolder.set(resp);
        sequenceHolder.set(resp != null ? new AtomicInteger() : null);
    }

    protected void append(ILoggingEvent event) {
        if (!this.isStarted()) {
            return;
        }
        try {
            String response;
            HttpServletResponse servletResponse;
            if (event instanceof DeferredProcessingAware) {
                event.prepareForDeferredProcessing();
            }
            if ((servletResponse = responseHolder.get()) == null) {
                return;
            }
            if (!servletResponse.containsHeader("X-Wf-Protocol-1")) {
                servletResponse.setHeader("X-Wf-Protocol-1", "http://meta.wildfirehq.org/Protocol/JsonStream/0.2");
                servletResponse.setHeader("X-Wf-1-Plugin-1", "http://meta.firephp.org/Wildfire/Plugin/FirePHP/Library-FirePHPCore/0.3");
                servletResponse.setHeader("X-Wf-1-Structure-1", "http://meta.firephp.org/Wildfire/Structure/FirePHP/FirebugConsole/0.1");
            }
            if ((response = this.createLogResponse(event)) != null) {
                StringBuilder header = new StringBuilder(4100);
                header.append(response.length());
                while (response.length() > 4000) {
                    header.append('|');
                    header.append(response.substring(0, 4000));
                    header.append("|\\");
                    servletResponse.setHeader("X-Wf-1-1-1-" + sequenceHolder.get().incrementAndGet(), header.toString());
                    header.setLength(0);
                    response = response.substring(4000);
                }
                header.append('|');
                header.append(response);
                header.append('|');
                servletResponse.setHeader("X-Wf-1-1-1-" + sequenceHolder.get().incrementAndGet(), header.toString());
            }
        }
        catch (IOException ioe) {
            this.started = false;
            this.addStatus((Status)new ErrorStatus("IO failure in appender", (Object)this, (Throwable)ioe));
        }
    }

    private String createLogResponse(ILoggingEvent event) throws IOException {
        StringWriter writer = new StringWriter(2048);
        JsonGenerator json = new JsonFactory().createJsonGenerator((Writer)writer);
        String type = WildfireAppender.getType(event);
        StackTraceElement[] callerData = event.getCallerData();
        String file = callerData != null ? callerData[0].getFileName() : null;
        int line = callerData != null ? callerData[0].getLineNumber() : 0;
        String label = event.getFormattedMessage();
        json.writeStartArray();
        json.writeStartObject();
        json.writeFieldName("Type");
        json.writeString(type);
        json.writeFieldName("File");
        if (file != null) {
            json.writeString(file);
        } else {
            json.writeNull();
        }
        json.writeFieldName("Line");
        if (line > 0) {
            json.writeNumber(line);
        } else {
            json.writeNull();
        }
        json.writeFieldName("Label");
        if (label != null) {
            json.writeString(label);
        } else {
            json.writeNull();
        }
        json.writeEndObject();
        json.writeString("");
        json.writeEndArray();
        json.flush();
        return writer.toString();
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void start() {
        super.start();
    }

    public void stop() {
        super.stop();
    }
}

