/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jetty.internal.handlers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.gyrex.http.jetty.internal.HttpJettyActivator;
import org.eclipse.gyrex.http.jetty.internal.handlers.DefaultErrorHandler;
import org.eclipse.gyrex.server.Platform;
import org.eclipse.jetty.util.ByteArrayISO8859Writer;

public class ErrorPage {
    public static final String NEWLINE = "\n";
    private static final String GENERATOR = "Gyrex Error Handler";
    private final boolean showDebugInfo = Platform.inDebugMode() || Platform.inDevelopmentMode();
    private int code;
    private String officialMessage;
    private String internalMessage;

    public static final void writeEscaped(Writer writer, Object object) throws IOException {
        if (object == null) {
            return;
        }
        String string = object.toString();
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    writer.write("&amp;");
                    break;
                }
                case '<': {
                    writer.write("&lt;");
                    break;
                }
                case '>': {
                    writer.write("&gt;");
                    break;
                }
                default: {
                    if (Character.isISOControl(c) && !Character.isWhitespace(c)) {
                        writer.write(63);
                        break;
                    }
                    writer.write(c);
                }
            }
            ++i;
        }
    }

    private String getAdminServerURL(HttpServletRequest request) {
        return "http://".concat(request.getServerName()).concat(":3110/");
    }

    public int getCode() {
        return this.code;
    }

    private Throwable getException(HttpServletRequest request) {
        return (Throwable)request.getAttribute("javax.servlet.error.exception");
    }

    private String getOverallStatusImage(IStatus status) {
        switch (status.getSeverity()) {
            case 4: 
            case 8: {
                return "/_error/error.gif";
            }
            case 2: {
                return "/_error/warning.gif";
            }
        }
        return "/_error/information.gif";
    }

    private String getOverallStatusMessage(IStatus status) {
        switch (status.getSeverity()) {
            case 4: 
            case 8: {
                return "It looks like that this server is not configured properly.";
            }
            case 2: {
                return "It looks like that the platform configuration is not perfect.";
            }
        }
        return "The platform configuration looks okay. Some hints/notes are available, though.";
    }

    private String getStatusImage(IStatus status) {
        switch (status.getSeverity()) {
            case 4: 
            case 8: {
                return "/_error/error.gif";
            }
            case 2: {
                return "/_error/warning.gif";
            }
        }
        return "/_error/information.gif";
    }

    public void render(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html;charset=ISO-8859-1");
        ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer(8192);
        this.writeErrorPage(request, (Writer)writer);
        response.setContentLength(writer.size());
        ServletOutputStream out = response.getOutputStream();
        writer.writeTo((OutputStream)out);
        out.close();
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setInternalMessage(String internalMessage) {
        this.internalMessage = internalMessage;
    }

    public void setOfficialMessage(String officialMessage) {
        this.officialMessage = officialMessage;
    }

    protected void writeDebugInfo(HttpServletRequest request, Writer writer) throws IOException {
        Throwable exception = this.getException(request);
        if (exception != null) {
            writer.write("<div class=\"dev_note\">");
            writer.write("<div><img src=\"/_error/error.gif\" style=\"float:left;padding-right:1em;\">The server throw an exception while processing the request. <span id=\"showstack\"><small><a href=\"#stack-trace\" onclick=\"javascript:document.getElementById('stack').style.display='block';document.getElementById('showstack').style.display='none';return false;\">Show stack.</a></small></span></div>");
            writer.write("<div id=\"stack\" style=\"display:none;\">");
            writer.write("<div style=\"clear:both;\"></div>");
            writer.write("<a name=\"stack-trace\" />");
            writer.write("<pre>");
            this.writeException(exception, writer);
            writer.write("</pre>");
            writer.write("</div>");
            writer.write("</div>");
        }
    }

    protected void writeErrorPage(HttpServletRequest request, Writer writer) throws IOException, UnsupportedEncodingException {
        writer.write("<html>");
        writer.write(NEWLINE);
        writer.write("<head>");
        writer.write(NEWLINE);
        writer.write("<title>Error ");
        writer.write(Integer.toString(this.code));
        writer.write(" - ");
        ErrorPage.writeEscaped(writer, this.officialMessage);
        writer.write("</title>");
        writer.write(NEWLINE);
        writer.write("<meta name=\"generator\" content=\"Gyrex Error Handler\">");
        writer.write(NEWLINE);
        writer.write("<link rel=\"stylesheet\" href=\"/_error/error.css\" type=\"text/css\">");
        writer.write(NEWLINE);
        writer.write("</head>");
        writer.write(NEWLINE);
        writer.write("<body>");
        writer.write(NEWLINE);
        writer.write("<h2>Error ");
        writer.write(Integer.toString(this.code));
        writer.write(" - ");
        ErrorPage.writeEscaped(writer, this.officialMessage);
        writer.write("</h2>");
        writer.write(NEWLINE);
        if (this.showDebugInfo) {
            if (this.internalMessage != null) {
                writer.write("<p>");
                this.writeFormattedMessage(writer, this.internalMessage);
                writer.write("</p>");
                writer.write(NEWLINE);
            }
            this.writeDebugInfo(request, writer);
            this.writePlatformStatus(request, writer);
        } else {
            writer.write("<p class=\"list-desc\">If you think you've reached this page in error:</p><ul><li>Make sure the URL you're trying to reach is correct.</li></ul><p class=\"list-desc\">Otherwise, you can:</p><ul><li>Go <a href=\"javascript:history.back()\">back to the previous page</a></li></ul>");
        }
        writer.write("<p align=\"right\"><em>Brought to you by Gyrex. Powered by Jetty and Equinox.</em></p>");
        int i = 0;
        while (i < 20) {
            writer.write(NEWLINE);
            writer.write("                                                ");
            ++i;
        }
        writer.write("</body>");
        writer.write(NEWLINE);
        writer.write("</html>");
        writer.write(NEWLINE);
    }

    protected void writeException(Throwable exception, Writer writer) {
        exception.printStackTrace(new PrintWriter(writer));
    }

    protected void writeFormattedMessage(Writer writer, String internalMessage) throws IOException {
        boolean inQuote = false;
        int i = 0;
        while (i < internalMessage.length()) {
            char c = internalMessage.charAt(i);
            if (c == '\'') {
                if (!inQuote) {
                    writer.write("'<code>");
                    inQuote = true;
                } else {
                    inQuote = false;
                    writer.write("</code>'");
                }
            } else {
                ErrorPage.writeEscaped(writer, String.valueOf(c));
            }
            ++i;
        }
        if (inQuote) {
            writer.write("</code>'");
        }
    }

    protected void writePlatformStatus(HttpServletRequest request, Writer writer) throws IOException, UnsupportedEncodingException {
        IStatus platformStatus = HttpJettyActivator.getPlatformStatus();
        if (!platformStatus.isOK()) {
            writer.write("<div class=\"dev_note\">");
            writer.write("<div><img src=\"" + this.getOverallStatusImage(platformStatus) + "\" style=\"float:left;padding-right:1em;\">" + this.getOverallStatusMessage(platformStatus) + "<br><em>You might want to check the <a href=\"" + this.getAdminServerURL(request) + "\">server configuration</a>.</em></div>");
            writer.write("<div style=\"clear:both;\"></div>");
            writer.write("<p>Issues detected on <code>");
            writer.write(DefaultErrorHandler.getServerName(request));
            writer.write("</code>:");
            this.writeStatus(platformStatus, writer);
            writer.write("</p>");
            writer.write("</div>");
        } else {
            writer.write("<div class=\"dev_note\">");
            writer.write("<div><img src=\"/_error/information.gif\" style=\"float:left;padding-right:1em;\">A note to developers, this server seems to be configured properly.<br><em>At least, no issues were detected.</em></div>");
            writer.write("<div style=\"clear:both;\"></div>");
            writer.write("</div>");
        }
    }

    protected void writeStackTrace(Writer writer, Throwable t) throws IOException {
        if (t != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.flush();
            ErrorPage.writeEscaped(writer, sw.getBuffer().toString());
        }
    }

    private void writeStatus(IStatus status, Writer writer) throws IOException, UnsupportedEncodingException {
        if (status.isOK()) {
            return;
        }
        writer.write("<ul class=\"status\">");
        String statusMessage = status.getMessage();
        if (status.isMultiStatus() && (statusMessage == null || statusMessage.trim().length() == 0)) {
            IStatus[] children;
            IStatus[] iStatusArray = children = status.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                this.writeStatusItem(child, writer, 0);
                ++n2;
            }
        } else {
            this.writeStatusItem(status, writer, 0);
        }
        writer.write("</ul>");
    }

    private void writeStatusItem(IStatus status, Writer writer, int identSize) throws IOException {
        if (status.isOK()) {
            return;
        }
        String ident = "";
        int i = 0;
        while (i < identSize) {
            ident = String.valueOf(ident) + " ";
            ++i;
        }
        writer.write(ident);
        writer.write("<li class=\"statusitem\">");
        writer.write("<img class=\"statusimage\" src=\"" + this.getStatusImage(status) + "\">&nbsp;&nbsp;");
        writer.write("<span class=\"statusmessage\">");
        ErrorPage.writeEscaped(writer, status.getMessage());
        writer.write("<br><small><code>(");
        ErrorPage.writeEscaped(writer, status.getPlugin());
        writer.write(", code ");
        ErrorPage.writeEscaped(writer, String.valueOf(status.getCode()));
        writer.write(")</code></small>");
        Throwable statusException = status.getException();
        if (statusException != null) {
            writer.write("<br>");
            writer.write(ident);
            writer.write("<pre>");
            this.writeStackTrace(writer, statusException);
            writer.write(ident);
            writer.write("</pre></small>");
        }
        writer.write("</span>");
        if (status.isMultiStatus()) {
            IStatus[] children;
            writer.write("<br>");
            writer.write(ident);
            writer.write("<ul>");
            IStatus[] iStatusArray = children = status.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                this.writeStatusItem(child, writer, identSize + 4);
                ++n2;
            }
            writer.write(ident);
            writer.write("</ul>");
        }
        writer.write(ident);
        writer.write("</li>");
    }
}

