/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.application;

import java.util.Collections;
import java.util.List;
import org.eclipse.gyrex.admin.ui.internal.application.AdminUiUtil;
import org.eclipse.gyrex.admin.ui.internal.application.DropDownNavigation;
import org.eclipse.gyrex.admin.ui.internal.pages.registry.AdminPageRegistry;
import org.eclipse.gyrex.admin.ui.internal.pages.registry.CategoryContribution;
import org.eclipse.gyrex.admin.ui.internal.pages.registry.PageContribution;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class Navigation {
    private final Composite composite;
    private final List<CategoryContribution> categories;

    public Navigation(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)AdminUiUtil.createGridLayoutWithoutMargin(9, false));
        this.composite.setData("org.eclipse.rwt.themeVariant", (Object)"navigation");
        this.categories = AdminPageRegistry.getInstance().getCategories();
        Collections.sort(this.categories);
        this.createNavigationControls(this.composite);
    }

    private void changeSelectedDropDownEntry(PageContribution page, DropDownNavigation navEntry) {
        navEntry.setSelected(this.pageBelongsToDropDownNav(page, navEntry));
    }

    private void createNavigationControls(Composite parent) {
        for (CategoryContribution category : this.categories) {
            this.createNavigationDropDown(parent, category);
        }
    }

    private void createNavigationDropDown(Composite parent, CategoryContribution category) {
        new DropDownNavigation(parent, category){

            @Override
            protected void openPage(PageContribution page) {
                Navigation.this.openPage(page);
            }
        };
    }

    public PageContribution findInitialPage() {
        Control[] children;
        Control[] controlArray = children = this.composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof DropDownNavigation) {
                return ((DropDownNavigation)control).findFirstPage();
            }
            ++n2;
        }
        return null;
    }

    public Control getControl() {
        return this.composite;
    }

    protected abstract void openPage(PageContribution var1);

    private boolean pageBelongsToDropDownNav(PageContribution page, DropDownNavigation navEntry) {
        CategoryContribution category = navEntry.getCategory();
        return category.getId().equals(page.getCategoryId());
    }

    public void selectNavigationEntry(PageContribution page) {
        Control[] children;
        Control[] controlArray = children = this.composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof DropDownNavigation) {
                this.changeSelectedDropDownEntry(page, (DropDownNavigation)control);
            }
            ++n2;
        }
    }
}

