/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.cloud.internal;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.gyrex.cloud.admin.ICloudManager;
import org.eclipse.gyrex.cloud.admin.INodeDescriptor;
import org.eclipse.gyrex.cloud.admin.INodeListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;

public final class NodeBrowserContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final INodeListener nodeListener = new INodeListener(){

        public void nodesChanged() {
            final Viewer viewer = NodeBrowserContentProvider.this.viewer;
            final Control control = viewer.getControl();
            if (control != null && !control.isDisposed()) {
                control.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!control.isDisposed()) {
                            viewer.refresh();
                        }
                    }
                });
            }
        }
    };
    Viewer viewer;

    private void attach(Object input) {
        if (input instanceof ICloudManager) {
            ((ICloudManager)input).addNodeListener(this.nodeListener);
        }
    }

    private void detach(Object input) {
        if (input instanceof ICloudManager) {
            ((ICloudManager)input).removeNodeListener(this.nodeListener);
        }
    }

    public void dispose() {
        if (this.viewer != null) {
            this.detach(this.viewer.getInput());
            this.viewer = null;
        }
    }

    public Object[] getChildren(Object parentElement) {
        return EMPTY_ARRAY;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof ICloudManager) {
            ArrayList<NodeItem> nodes = new ArrayList<NodeItem>();
            ICloudManager cloudManager = (ICloudManager)inputElement;
            Set onlineNodes = cloudManager.getOnlineNodes();
            for (INodeDescriptor nodeDescriptor : cloudManager.getApprovedNodes()) {
                nodes.add(new NodeItem(true, onlineNodes.contains(nodeDescriptor.getId()), nodeDescriptor));
            }
            for (INodeDescriptor nodeDescriptor : cloudManager.getPendingNodes()) {
                nodes.add(new NodeItem(false, onlineNodes.contains(nodeDescriptor.getId()), nodeDescriptor));
            }
            return nodes.toArray();
        }
        return EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return false;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.viewer != null && this.viewer != viewer) {
            throw new IllegalStateException("please use separate provider instance for different viewers");
        }
        this.viewer = viewer;
        this.detach(oldInput);
        this.attach(newInput);
    }

    public static final class NodeItem {
        private final boolean approved;
        private final boolean online;
        private final INodeDescriptor descriptor;

        public NodeItem(boolean approved, boolean online, INodeDescriptor descriptor) {
            this.approved = approved;
            this.online = online;
            this.descriptor = descriptor;
        }

        public INodeDescriptor getDescriptor() {
            return this.descriptor;
        }

        public boolean isApproved() {
            return this.approved;
        }

        public boolean isOnline() {
            return this.online;
        }
    }
}

