/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.context.internal.commands;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gyrex.common.console.Command;
import org.eclipse.gyrex.context.internal.ContextActivator;
import org.eclipse.gyrex.context.internal.registry.ContextDefinition;
import org.eclipse.gyrex.context.internal.registry.ContextRegistryImpl;
import org.kohsuke.args4j.Argument;

public class DefineContextCmd
extends Command {
    @Argument(index=0, usage="the context path", required=true, metaVar="PATH")
    String pathStr;
    @Argument(index=1, usage="the context name", required=true, metaVar="NAME")
    String name;

    public DefineContextCmd() {
        super("<path> <name> - defines a context");
    }

    protected void doExecute() throws Exception {
        if (StringUtils.isBlank((String)this.pathStr) || !Path.EMPTY.isValidPath(this.pathStr)) {
            this.ci.println((Object)"ERROR: invalid path");
            return;
        }
        if (StringUtils.isBlank((String)this.name)) {
            this.ci.println((Object)"ERROR: invalid name");
            return;
        }
        ContextDefinition definition = new ContextDefinition((IPath)new Path(this.pathStr));
        definition.setName(this.name);
        this.getRegistry().saveDefinition(definition);
        this.ci.println((Object)"context defined");
    }

    protected ContextRegistryImpl getRegistry() {
        return ContextActivator.getInstance().getContextRegistryImpl();
    }
}

