/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import org.apache.derby.client.ClientPooledConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.LogicalDatabaseMetaData;
import org.apache.derby.client.am.PreparedStatement;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;

public class LogicalConnection
implements java.sql.Connection {
    protected Connection physicalConnection_ = null;
    private ClientPooledConnection pooledConnection_ = null;
    private LogicalDatabaseMetaData logicalDatabaseMetaData = null;

    public LogicalConnection(Connection physicalConnection, ClientPooledConnection pooledConnection) throws SqlException {
        this.physicalConnection_ = physicalConnection;
        this.pooledConnection_ = pooledConnection;
        try {
            this.checkForNullPhysicalConnection();
        }
        catch (SQLException se) {
            throw new SqlException(se);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public synchronized void nullPhysicalConnection() {
        this.physicalConnection_ = null;
    }

    public synchronized void close() throws SQLException {
        try {
            if (this.physicalConnection_ == null) {
                return;
            }
            if (this.physicalConnection_.agent_.loggingEnabled()) {
                this.physicalConnection_.agent_.logWriter_.traceEntry(this, "close");
            }
            if (this.physicalConnection_.isClosed()) {
                this.pooledConnection_.informListeners(new SqlException(null, new ClientMessageId("08003.C.3")));
            } else {
                this.physicalConnection_.checkForTransactionInProgress();
                this.physicalConnection_.closeForReuse(this.pooledConnection_.isStatementPoolingEnabled());
                if (!this.physicalConnection_.isGlobalPending_()) {
                    this.pooledConnection_.recycleConnection();
                }
            }
            this.physicalConnection_ = null;
            this.pooledConnection_.nullLogicalConnection();
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void closeWithoutRecyclingToPool() throws SqlException {
        if (this.physicalConnection_ == null) {
            return;
        }
        this.physicalConnection_.checkForTransactionInProgress();
        try {
            if (this.physicalConnection_.isClosed()) {
                throw new SqlException(null, new ClientMessageId("08003"));
            }
        }
        finally {
            this.physicalConnection_.closeForReuse(this.pooledConnection_.isStatementPoolingEnabled());
            this.physicalConnection_ = null;
        }
    }

    public boolean isClosed() throws SQLException {
        if (this.physicalConnection_ == null) {
            return true;
        }
        return this.physicalConnection_.isClosed();
    }

    protected void checkForNullPhysicalConnection() throws SQLException {
        if (this.physicalConnection_ == null) {
            SqlException se = new SqlException(null, new ClientMessageId("08003"));
            throw se.getSQLException();
        }
    }

    final void notifyException(SQLException sqle) {
        if (this.physicalConnection_ != null) {
            this.pooledConnection_.informListeners(new SqlException(sqle));
        }
    }

    public synchronized Statement createStatement() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.createStatement();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public synchronized java.sql.PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareStatement(sql);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public synchronized PreparedStatement preparePositionedUpdateStatement(String sql, Section querySection) throws SqlException {
        try {
            this.checkForNullPhysicalConnection();
        }
        catch (SQLException se) {
            throw new SqlException(se);
        }
        return this.physicalConnection_.preparePositionedUpdateStatement(sql, querySection);
    }

    public synchronized CallableStatement prepareCall(String sql) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareCall(sql);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.nativeSQL(sql);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.setAutoCommit(autoCommit);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getAutoCommit();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public synchronized void commit() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.commit();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public synchronized void rollback() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.rollback();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public synchronized void setTransactionIsolation(int level) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.setTransactionIsolation(level);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public int getTransactionIsolation() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getTransactionIsolation();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getWarnings();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public synchronized void clearWarnings() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.clearWarnings();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            if (this.logicalDatabaseMetaData == null) {
                this.logicalDatabaseMetaData = this.newLogicalDatabaseMetaData();
            }
            return this.logicalDatabaseMetaData;
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    protected LogicalDatabaseMetaData newLogicalDatabaseMetaData() throws SQLException {
        return new LogicalDatabaseMetaData(this, this.physicalConnection_.agent_.logWriter_);
    }

    final synchronized DatabaseMetaData getRealMetaDataObject() throws SQLException {
        if (this.isClosed()) {
            throw new SqlException(this.physicalConnection_ == null ? null : this.physicalConnection_.agent_.logWriter_, new ClientMessageId("08003")).getSQLException();
        }
        return this.physicalConnection_.getMetaData();
    }

    public synchronized void setReadOnly(boolean readOnly) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.setReadOnly(readOnly);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public boolean isReadOnly() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.isReadOnly();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public synchronized void setCatalog(String catalog) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.setCatalog(catalog);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public String getCatalog() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getCatalog();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public synchronized java.sql.PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public Map getTypeMap() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getTypeMap();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public synchronized void setTypeMap(Map map) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.setTypeMap(map);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public java.sql.PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public java.sql.PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareStatement(sql, autoGeneratedKeys);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public java.sql.PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareStatement(sql, columnIndexes);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public java.sql.PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareStatement(sql, columnNames);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public void setHoldability(int holdability) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.setHoldability(holdability);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public int getHoldability() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getHoldability();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.setSavepoint();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.setSavepoint(name);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.rollback(savepoint);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.releaseSavepoint(savepoint);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public int getServerVersion() {
        if (this.physicalConnection_ == null) {
            return -1;
        }
        return this.physicalConnection_.getServerVersion();
    }
}

