/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;

public class ColumnDescriptorList
extends ArrayList {
    public void add(UUID tableID, ColumnDescriptor column) {
        this.add(column);
    }

    public ColumnDescriptor getColumnDescriptor(UUID tableID, String columnName) {
        ColumnDescriptor returnValue = null;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ColumnDescriptor columnDescriptor = (ColumnDescriptor)iterator.next();
            if (!columnName.equals(columnDescriptor.getColumnName()) || !tableID.equals(columnDescriptor.getReferencingUUID())) continue;
            returnValue = columnDescriptor;
            break;
        }
        return returnValue;
    }

    public ColumnDescriptor getColumnDescriptor(UUID tableID, int columnID) {
        ColumnDescriptor returnValue = null;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ColumnDescriptor columnDescriptor = (ColumnDescriptor)iterator.next();
            if (columnID != columnDescriptor.getPosition() || !tableID.equals(columnDescriptor.getReferencingUUID())) continue;
            returnValue = columnDescriptor;
            break;
        }
        return returnValue;
    }

    public ColumnDescriptor elementAt(int n) {
        return (ColumnDescriptor)this.get(n);
    }

    public String[] getColumnNames() {
        String[] strings = new String[this.size()];
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ColumnDescriptor columnDescriptor = this.elementAt(index);
            strings[index] = columnDescriptor.getColumnName();
        }
        return strings;
    }
}

