/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.text.CollationElementIterator;
import java.text.CollationKey;
import java.text.RuleBasedCollator;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.CollationElementsInterface;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.Like;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLChar;

final class WorkHorseForCollatorDatatypes {
    private RuleBasedCollator collatorForCharacterDatatypes;
    private SQLChar stringData;
    private int[] collationElementsForString;
    private int countOfCollationElements;
    private CollationKey cKey;

    WorkHorseForCollatorDatatypes(RuleBasedCollator collatorForCharacterDatatypes, SQLChar stringData) {
        this.collatorForCharacterDatatypes = collatorForCharacterDatatypes;
        this.stringData = stringData;
    }

    int stringCompare(SQLChar str1, SQLChar str2) throws StandardException {
        CollationKey ckey1 = str1.getCollationKey();
        CollationKey ckey2 = str2.getCollationKey();
        if (ckey1 == null || ckey2 == null) {
            if (ckey1 != null) {
                return -1;
            }
            if (ckey2 != null) {
                return 1;
            }
            return 0;
        }
        return ckey1.compareTo(ckey2);
    }

    BooleanDataValue like(DataValueDescriptor pattern) throws StandardException {
        SanityManager.ASSERT(pattern instanceof CollationElementsInterface, "Both the operands must be instances of CollationElementsInterface");
        Boolean likeResult = Like.like(this.stringData.getCharArray(), this.stringData.getLength(), ((SQLChar)pattern).getCharArray(), pattern.getLength(), null, 0, this.collatorForCharacterDatatypes);
        return SQLBoolean.truthValue((DataValueDescriptor)this.stringData, pattern, likeResult);
    }

    BooleanDataValue like(DataValueDescriptor pattern, DataValueDescriptor escape) throws StandardException {
        SanityManager.ASSERT(pattern instanceof CollationElementsInterface && escape instanceof CollationElementsInterface, "All three operands must be instances of CollationElementsInterface");
        if (escape.isNull()) {
            throw StandardException.newException("22501");
        }
        CollationElementsInterface escapeCharacter = (CollationElementsInterface)((Object)escape);
        if (escapeCharacter.getCollationElementsForString() != null && escapeCharacter.getCountOfCollationElements() != 1) {
            throw StandardException.newException("22019", new String(escapeCharacter.toString()));
        }
        Boolean likeResult = Like.like(this.stringData.getCharArray(), this.stringData.getLength(), ((SQLChar)pattern).getCharArray(), pattern.getLength(), ((SQLChar)escape).getCharArray(), escape.getLength(), this.collatorForCharacterDatatypes);
        return SQLBoolean.truthValue((DataValueDescriptor)this.stringData, pattern, likeResult);
    }

    RuleBasedCollator getCollatorForCollation() {
        return this.collatorForCharacterDatatypes;
    }

    int getCountOfCollationElements() {
        return this.countOfCollationElements;
    }

    int[] getCollationElementsForString() throws StandardException {
        int nextInt;
        if (this.stringData.isNull()) {
            return null;
        }
        this.collationElementsForString = null;
        this.countOfCollationElements = 0;
        if (this.collationElementsForString != null) {
            return this.collationElementsForString;
        }
        if (this.countOfCollationElements != 0) {
            SanityManager.THROWASSERT("countOfCollationElements expected to be 0, not " + this.countOfCollationElements);
        }
        this.collationElementsForString = new int[this.stringData.getLength()];
        CollationElementIterator cei = this.collatorForCharacterDatatypes.getCollationElementIterator(this.stringData.getString());
        while ((nextInt = cei.next()) != -1) {
            if (this.countOfCollationElements == this.collationElementsForString.length) {
                int[] expandedArray = new int[this.countOfCollationElements + 5];
                System.arraycopy(this.collationElementsForString, 0, expandedArray, 0, this.collationElementsForString.length);
                this.collationElementsForString = expandedArray;
            }
            this.collationElementsForString[this.countOfCollationElements++] = nextInt;
        }
        return this.collationElementsForString;
    }
}

