/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FormatableProperties;
import org.apache.derby.iapi.util.PropertyUtil;
import org.apache.derby.impl.sql.execute.rts.RealNoPutResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.ResultSetStatistics;

public class RealSortStatistics
extends RealNoPutResultSetStatistics {
    public int rowsInput;
    public int rowsReturned;
    public boolean eliminateDuplicates;
    public boolean inSortedOrder;
    public ResultSetStatistics childResultSetStatistics;
    public FormatableProperties sortProperties;

    public RealSortStatistics(int numOpens, int rowsSeen, int rowsFiltered, long constructorTime, long openTime, long nextTime, long closeTime, int resultSetNumber, int rowsInput, int rowsReturned, boolean eliminateDuplicates, boolean inSortedOrder, Properties sortProperties, double optimizerEstimatedRowCount, double optimizerEstimatedCost, ResultSetStatistics childResultSetStatistics) {
        super(numOpens, rowsSeen, rowsFiltered, constructorTime, openTime, nextTime, closeTime, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.rowsInput = rowsInput;
        this.rowsReturned = rowsReturned;
        this.eliminateDuplicates = eliminateDuplicates;
        this.inSortedOrder = inSortedOrder;
        this.childResultSetStatistics = childResultSetStatistics;
        this.sortProperties = new FormatableProperties();
        Enumeration<Object> e = sortProperties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.sortProperties.put(key, sortProperties.get(key));
        }
    }

    public String getStatementExecutionPlanText(int depth) {
        this.initFormatInfo(depth);
        String sortInfo = this.inSortedOrder ? "" : this.indent + MessageService.getTextMessage("43X40.U") + ": \n" + PropertyUtil.sortProperties(this.sortProperties, this.subIndent);
        return this.indent + MessageService.getTextMessage("43Y06.U") + ":\n" + this.indent + MessageService.getTextMessage("43X03.U") + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage("43X21.U") + " = " + this.rowsInput + "\n" + this.indent + MessageService.getTextMessage("43X81.U") + " = " + this.rowsReturned + "\n" + this.indent + MessageService.getTextMessage("43Y07.U") + " = " + this.eliminateDuplicates + "\n" + this.indent + MessageService.getTextMessage("43X43.U") + " = " + this.inSortedOrder + "\n" + sortInfo + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + this.dumpEstimatedCosts(this.subIndent) + "\n" + this.indent + MessageService.getTextMessage("43X05.U") + ":\n" + this.childResultSetStatistics.getStatementExecutionPlanText(this.sourceDepth) + "\n";
    }

    public String getScanStatisticsText(String tableName, int depth) {
        return this.childResultSetStatistics.getScanStatisticsText(tableName, depth);
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    public Vector getChildren() {
        Vector<ResultSetStatistics> children = new Vector<ResultSetStatistics>();
        children.addElement(this.childResultSetStatistics);
        return children;
    }

    public String getNodeName() {
        return MessageService.getTextMessage("43Y08.U");
    }
}

